/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util.alg.digest;

import com.pax.market.api.sdk.java.base.util.alg.digest.IDigest;

public abstract class DigestBase
implements IDigest {
    protected String algName;
    protected int digestLen;
    protected int blockLen;
    protected byte[] xBuf = new byte[4];
    protected int xBufOff = 0;
    protected long byteCount;

    @Override
    public String getAlgorithmName() {
        return this.algName;
    }

    @Override
    public int getBlockLength() {
        return this.blockLen;
    }

    @Override
    public int getDigestLength() {
        return this.digestLen;
    }

    @Override
    public void update(byte paramByte) {
        this.xBuf[this.xBufOff++] = paramByte;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] paramArrayOfByte) {
        this.update(paramArrayOfByte, 0, paramArrayOfByte.length);
    }

    @Override
    public void update(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        while (this.xBufOff != 0 && paramInt2 > 0) {
            this.update(paramArrayOfByte[paramInt1]);
            ++paramInt1;
            --paramInt2;
        }
        while (paramInt2 > this.xBuf.length) {
            this.processWord(paramArrayOfByte, paramInt1);
            paramInt1 += this.xBuf.length;
            paramInt2 -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (paramInt2 > 0) {
            this.update(paramArrayOfByte[paramInt1]);
            ++paramInt1;
            --paramInt2;
        }
    }

    @Override
    public void digest(byte[] paramArrayOfByte) {
        this.digest(paramArrayOfByte, 0);
    }

    @Override
    public byte[] digest() {
        byte[] arrayOfByte = new byte[this.digestLen];
        this.digest(arrayOfByte);
        return arrayOfByte;
    }

    protected void finish() {
        long l = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l);
        this.processBlock();
    }

    @Override
    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i = 0; i < this.xBuf.length; ++i) {
            this.xBuf[i] = 0;
        }
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();
}

