/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.base.constant.ResultCode;
import com.pax.market.api.sdk.java.base.dto.SdkObject;

public class JsonUtils {
    private static Gson gson = JsonUtils.getGson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Gson getGson() {
        if (gson != null) return gson;
        Class<Gson> clazz = Gson.class;
        synchronized (Gson.class) {
            if (gson != null) return gson;
            gson = new Gson();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gson;
        }
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static <T> T fromJson(String sdkJsonStr, Class<T> clazz) {
        return (T)gson.fromJson(sdkJsonStr, clazz);
    }

    public static String getSdkJson(int resultCode, String errorMsg) {
        String message = "";
        switch (ResultCode.toResultCode(resultCode)) {
            case SDK_PARAM_ERROR: {
                message = "Sdk param error";
                break;
            }
            case SDK_UNINIT: {
                message = "Sdk uninit";
                break;
            }
            case SDK_DEC_ERROR: {
                message = "Sdk decrypt error";
                break;
            }
            case SDK_JSON_ERROR: {
                message = "Sdk json error";
                break;
            }
            case SDK_CONNECT_TIMEOUT: {
                message = "Sdk connect timeout";
                break;
            }
            case SDK_UN_CONNECT: {
                message = "Sdk unconnect";
                break;
            }
            case SDK_RQUEST_EXCEPTION: {
                message = "Sdk rquest exception";
                break;
            }
            case SDK_UNZIP_FAILED: {
                message = "Sdk unzip failed";
                break;
            }
            case SDK_MD_FAILED: {
                message = "Sdk md failed";
                break;
            }
            case SDK_REPLACE_VARIABLES_FAILED: {
                message = "Sdk replace variables failed";
                break;
            }
            case SDK_INIT_FAILED: {
                message = "Sdk init failed";
                break;
            }
            case SDK_FILE_NOT_FOUND: {
                message = "Sdk file not found";
            }
        }
        message = message + ":" + errorMsg;
        return JsonUtils.getSdkJsonStr(resultCode, message);
    }

    public static String getSdkJsonStr(int resultCode, String message) {
        SdkObject sdkObject = new SdkObject();
        sdkObject.setBusinessCode(resultCode);
        sdkObject.setMessage(message);
        return JsonUtils.toJson(sdkObject);
    }
}

