/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.param;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.pax.market.api.sdk.java.base.api.BaseApi;
import com.pax.market.api.sdk.java.base.constant.ResultCode;
import com.pax.market.api.sdk.java.base.dto.DownloadResultObject;
import com.pax.market.api.sdk.java.base.dto.InnerDownloadResultObject;
import com.pax.market.api.sdk.java.base.dto.LastFailObject;
import com.pax.market.api.sdk.java.base.dto.ParamListObject;
import com.pax.market.api.sdk.java.base.dto.ParamObject;
import com.pax.market.api.sdk.java.base.dto.SdkObject;
import com.pax.market.api.sdk.java.base.dto.UpdateActionObject;
import com.pax.market.api.sdk.java.base.exception.ParseXMLException;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import com.pax.market.api.sdk.java.base.util.Md5Utils;
import com.pax.market.api.sdk.java.base.util.ReplaceUtils;
import com.pax.market.api.sdk.java.base.util.ZipUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamApi
extends BaseApi {
    public static final String REMARKS_PARAM_DOWNLOADING = "15206";
    public static final int ACT_STATUS_PENDING = 1;
    public static final int ACT_STATUS_SUCCESS = 2;
    public static final int ACT_STATUS_FAILED = 3;
    public static final int CODE_NONE_ERROR = 0;
    public static final int CODE_DOWNLOAD_ERROR = 1;
    public static final int RETRY_COUNT = 20;
    public static final long RETRY_TIME_LIMIT = 864000000L;
    public static final long GET_SUCCESS_PARAM_LIMIT = 60000L;
    private static final String REQ_PARAM_PACKAGE_NAME = "packageName";
    private static final String REQ_PARAM_VERSION_CODE = "versionCode";
    private static final String REQ_PARAM_STATUS = "status";
    private static final String REQ_PARAM_ERROR_CODE = "errorCode";
    private static final String REQ_PARAM_REMARKS = "remarks";
    private static final String REQ_PARAM_TEMPLATE_NAME = "paramTemplateName";
    private static final String ERROR_REMARKS_REPLACE_VARIABLES = "Replace paramVariables failed";
    private static final String ERROR_REMARKS_NOT_GOOD_JSON = "Bad json : ";
    private static final String ERROR_REMARKS_VARIFY_MD_FAILED = "MD5 Validation Error";
    private static final String ERROR_UNZIP_FAILED = "Unzip file failed";
    private static final String DOWNLOAD_SUCCESS = "Success";
    public static final String ERROR_CELLULAR_NOT_ALLOWED = "Cellular download not allowed";
    private static final String SAVEPATH_CANNOT_BE_NULL = "Save path can not be empty";
    protected static String downloadParamUrl = "v1/3rdApps/param";
    protected static String updateStatusUrl = "v1/3rdApps/actions/{actionId}/status";
    protected static String updateStatusBatchUrl = "v1/3rdApps/actions";
    protected static String lastSuccessParamUrl = "v1/3rdApps/param/last/success";
    private final Logger logger = LoggerFactory.getLogger((String)ParamApi.class.getSimpleName());
    private long lastGetTime = -1L;

    public ParamApi(String baseUrl, String appKey, String appSecret, String terminalSN) {
        super(baseUrl, appKey, appSecret, terminalSN);
    }

    public void setBaseUrl(String baseUrl) {
        super.getDefaultClient().setBaseUrl(baseUrl);
    }

    public ParamListObject getParamDownloadList(String packageName, int versionCode) {
        SdkRequest request = new SdkRequest(downloadParamUrl);
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.addRequestParam(REQ_PARAM_PACKAGE_NAME, packageName);
        request.addRequestParam(REQ_PARAM_VERSION_CODE, Integer.toString(versionCode));
        return JsonUtils.fromJson(this.call(request), ParamListObject.class);
    }

    public ParamObject getLastSuccessParm(String paramTemplateName) {
        this.logger.debug(this.lastGetTime + "");
        if (this.lastGetTime != -1L && System.currentTimeMillis() - this.lastGetTime < 60000L) {
            return this.createRateLimit();
        }
        this.lastGetTime = System.currentTimeMillis();
        SdkRequest request = new SdkRequest(lastSuccessParamUrl);
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        if (paramTemplateName != null) {
            request.addRequestParam(REQ_PARAM_TEMPLATE_NAME, paramTemplateName);
        }
        return JsonUtils.fromJson(this.call(request), ParamObject.class);
    }

    public ParamObject createRateLimit() {
        ParamObject paramObject = new ParamObject();
        paramObject.setBusinessCode(-1);
        paramObject.setMessage("Try again after one minute too frequently");
        return paramObject;
    }

    public ParamObject getLastSuccessParm() {
        return this.getLastSuccessParm(null);
    }

    private String cookieHeader(String signature, String expires, String keyPairId) {
        StringBuilder cookieHeader = new StringBuilder();
        if (expires == null && keyPairId == null) {
            cookieHeader.append("CloudFront-Signature").append('=').append(signature);
        } else {
            cookieHeader.append("CloudFront-Signature").append('=').append(signature);
            cookieHeader.append("; ");
            cookieHeader.append("CloudFront-Expires").append('=').append(expires);
            cookieHeader.append("; ");
            cookieHeader.append("CloudFront-Key-Pair-Id").append('=').append(keyPairId);
        }
        return cookieHeader.toString();
    }

    public DownloadResultObject downloadParamFileOnly(ParamObject paramObject, String saveFilePath) {
        String execute;
        SdkObject sdkObject;
        SdkRequest request = new SdkRequest(paramObject.getDownloadUrl());
        request.setSaveFilePath(saveFilePath);
        if (paramObject.getCookieSignature() != null) {
            String cookies = this.cookieHeader(paramObject.getCookieSignature(), paramObject.getCookieExpires(), paramObject.getCookieKeyPairId());
            request.addHeader("Cookie", cookies);
        }
        if ((sdkObject = JsonUtils.fromJson(execute = this.download(request), SdkObject.class)).getBusinessCode() == ResultCode.SUCCESS.getCode()) {
            if (paramObject.getMd() == null || paramObject.getMd().equals("") || paramObject.getMd().equals(Md5Utils.getFileMD5(new File(sdkObject.getMessage())))) {
                this.logger.debug("download file md5 is correct");
                boolean unzipResult = ZipUtil.unzip(sdkObject.getMessage());
                boolean deleteResult = com.pax.market.api.sdk.java.base.util.FileUtils.deleteFile(sdkObject.getMessage());
                if (!unzipResult || !deleteResult) {
                    sdkObject.setBusinessCode(ResultCode.SDK_UNZIP_FAILED.getCode());
                    sdkObject.setMessage(ERROR_UNZIP_FAILED);
                } else if (!ReplaceUtils.isHashMapJson(paramObject.getParamVariables())) {
                    sdkObject.setBusinessCode(ResultCode.SDK_REPLACE_VARIABLES_FAILED.getCode());
                    sdkObject.setMessage(ERROR_REMARKS_NOT_GOOD_JSON + paramObject.getParamVariables());
                } else {
                    boolean ifReplaceSuccess = ReplaceUtils.replaceParams(saveFilePath, paramObject.getParamVariables());
                    if (!ifReplaceSuccess) {
                        this.logger.info("replace paramVariables failed");
                        sdkObject.setBusinessCode(ResultCode.SDK_REPLACE_VARIABLES_FAILED.getCode());
                        sdkObject.setMessage(ERROR_REMARKS_REPLACE_VARIABLES);
                    }
                }
            } else {
                this.logger.debug("download file md5 is wrong");
                sdkObject.setBusinessCode(ResultCode.SDK_MD_FAILED.getCode());
                sdkObject.setMessage(ERROR_REMARKS_VARIFY_MD_FAILED);
            }
        }
        DownloadResultObject resultObject = new DownloadResultObject();
        resultObject.setMessage(sdkObject.getMessage());
        resultObject.setBusinessCode(sdkObject.getBusinessCode());
        resultObject.setParamSavePath(saveFilePath);
        return resultObject;
    }

    public SdkObject updateDownloadStatus(String actionId, int status, int errorCode, String remarks) {
        String requestUrl = updateStatusUrl.replace("{actionId}", actionId);
        SdkRequest request = new SdkRequest(requestUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.addRequestParam(REQ_PARAM_STATUS, Integer.toString(status));
        request.addRequestParam(REQ_PARAM_ERROR_CODE, Integer.toString(errorCode));
        request.addRequestParam(REQ_PARAM_REMARKS, remarks);
        return JsonUtils.fromJson(this.call(request), SdkObject.class);
    }

    public SdkObject updateDownloadStatusBatch(List<UpdateActionObject> updateActionObjectList) {
        String requestBody = JsonUtils.toJson(updateActionObjectList);
        SdkRequest request = new SdkRequest(updateStatusBatchUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.setRequestBody(requestBody);
        return JsonUtils.fromJson(this.call(request), SdkObject.class);
    }

    public InnerDownloadResultObject downloadParamToPath(String packageName, int versionCode, String saveFilePath, LastFailObject lastFailObject, boolean mobileNetAvailable) {
        this.logger.debug("downloadParamToPath: start");
        InnerDownloadResultObject result = new InnerDownloadResultObject();
        if (saveFilePath == null || "".equals(saveFilePath.trim())) {
            result.setBusinessCode(ResultCode.SDK_FILE_NOT_FOUND.getCode());
            result.setMessage(JsonUtils.getSdkJson(ResultCode.SDK_FILE_NOT_FOUND.getCode(), SAVEPATH_CANNOT_BE_NULL));
            return result;
        }
        result.setParamSavePath(saveFilePath);
        ParamListObject paramListObject = this.getParamDownloadList(packageName, versionCode);
        if (paramListObject.getBusinessCode() != ResultCode.SUCCESS.getCode()) {
            result.setBusinessCode(paramListObject.getBusinessCode());
            result.setMessage(paramListObject.getMessage());
            return result;
        }
        if (paramListObject.getTotalCount() == 0) {
            result.setBusinessCode(-10);
            result.setMessage("No params to download");
            return result;
        }
        List<UpdateActionObject> updateBatchBody = this.getUpdateBatchBody(paramListObject, REMARKS_PARAM_DOWNLOADING, 1, 0);
        this.updateDownloadStatusBatch(updateBatchBody);
        saveFilePath = saveFilePath + File.separator + paramListObject.getList().get(0).getActionId();
        String remarks = null;
        for (ParamObject paramObject : paramListObject.getList()) {
            if (paramObject.isWifiOnly() && mobileNetAvailable) {
                ParamListObject cellularForbidList = new ParamListObject();
                this.updateDownloadStatus(String.valueOf(paramObject.getActionId()), 0, 0, ERROR_CELLULAR_NOT_ALLOWED);
                result.setBusinessCode(ResultCode.SDK_DOWNLOAD_WITH_CELLULAR_NOT_ALLOWED.getCode());
                result.setMessage(ERROR_CELLULAR_NOT_ALLOWED);
                return result;
            }
            DownloadResultObject sdkObject = this.downloadParamFileOnly(paramObject, saveFilePath);
            if (sdkObject.getBusinessCode() == ResultCode.SUCCESS.getCode()) continue;
            this.setIOExceptionResult(lastFailObject, result, paramObject, sdkObject);
            result.setBusinessCode(sdkObject.getBusinessCode());
            result.setMessage(sdkObject.getMessage());
            remarks = sdkObject.getMessage();
            this.logger.debug("download error remarks: " + remarks);
            break;
        }
        if (remarks != null) {
            com.pax.market.api.sdk.java.base.util.FileUtils.delFolder(saveFilePath);
            this.updateActionListByRemarks(paramListObject, result, remarks);
        } else {
            SdkObject updateResultObj = this.updateActionListByRemarks(paramListObject, result, remarks);
            if (updateResultObj.getBusinessCode() != ResultCode.SUCCESS.getCode()) {
                com.pax.market.api.sdk.java.base.util.FileUtils.delFolder(saveFilePath);
                result.setBusinessCode(updateResultObj.getBusinessCode());
                result.setMessage(updateResultObj.getMessage());
            } else {
                com.pax.market.api.sdk.java.base.util.FileUtils.moveToFatherFolder(saveFilePath);
                result.setBusinessCode(ResultCode.SUCCESS.getCode());
                result.setMessage(DOWNLOAD_SUCCESS);
            }
        }
        this.logger.debug("downloadParamToPath: end");
        return result;
    }

    public InnerDownloadResultObject downloadLastSuccessParmToPath(String savePath) {
        return this.downloadLastSuccessParmToPath(savePath, null);
    }

    public InnerDownloadResultObject downloadLastSuccessParmToPath(String saveFilePath, String paramTemplateName) {
        this.logger.debug("downloadLastSuccessParmToPath: start");
        InnerDownloadResultObject result = new InnerDownloadResultObject();
        if (saveFilePath == null || "".equals(saveFilePath.trim())) {
            result.setBusinessCode(ResultCode.SDK_FILE_NOT_FOUND.getCode());
            result.setMessage(JsonUtils.getSdkJson(ResultCode.SDK_FILE_NOT_FOUND.getCode(), SAVEPATH_CANNOT_BE_NULL));
            return result;
        }
        result.setParamSavePath(saveFilePath);
        ParamObject paramObject = paramTemplateName != null ? this.getLastSuccessParm(paramTemplateName) : this.getLastSuccessParm();
        if (paramObject.getBusinessCode() != ResultCode.SUCCESS.getCode()) {
            result.setBusinessCode(paramObject.getBusinessCode());
            result.setMessage(paramObject.getMessage());
            return result;
        }
        saveFilePath = saveFilePath + File.separator + paramObject.getActionId();
        String remarks = null;
        DownloadResultObject sdkObject = this.downloadParamFileOnly(paramObject, saveFilePath);
        if (sdkObject.getBusinessCode() != ResultCode.SUCCESS.getCode()) {
            result.setBusinessCode(sdkObject.getBusinessCode());
            result.setMessage(sdkObject.getMessage());
            remarks = sdkObject.getMessage();
            this.logger.debug("download error remarks: " + remarks);
        }
        if (remarks != null) {
            com.pax.market.api.sdk.java.base.util.FileUtils.delFolder(saveFilePath);
        } else {
            com.pax.market.api.sdk.java.base.util.FileUtils.moveToFatherFolder(saveFilePath);
            result.setBusinessCode(ResultCode.SUCCESS.getCode());
            result.setMessage(DOWNLOAD_SUCCESS);
        }
        this.logger.debug("downloadLastSuccessParmToPath: end");
        return result;
    }

    private void setIOExceptionResult(LastFailObject lastFailObject, InnerDownloadResultObject result, ParamObject paramObject, SdkObject sdkObject) {
        if (sdkObject.getMessage() != null && sdkObject.getMessage().contains("IOException-")) {
            if (lastFailObject == null) {
                lastFailObject = new LastFailObject();
            }
            if (lastFailObject.getActionId() != paramObject.getActionId()) {
                lastFailObject.setFirstTryTime(System.currentTimeMillis());
                lastFailObject.setRetryCount(0);
            }
            lastFailObject.setActionId(paramObject.getActionId());
            lastFailObject.setRetryCount(lastFailObject.getRetryCount() + 1);
            result.setLastFailObject(lastFailObject);
        }
    }

    private SdkObject updateActionListByRemarks(ParamListObject paramListObject, InnerDownloadResultObject result, String remarks) {
        List<UpdateActionObject> updateBatchList;
        if (result.getMessage() != null && result.getMessage().contains("IOException-") && result.getLastFailObject() != null) {
            if (result.getLastFailObject().getRetryCount() > 20) {
                updateBatchList = this.getUpdateBatchBody(paramListObject, String.format(" Bad network connection, exceeded max retry times: %d . %s", 20, remarks), 3, 1);
            } else if (result.getLastFailObject().getFirstTryTime() + 864000000L < System.currentTimeMillis()) {
                updateBatchList = this.getUpdateBatchBody(paramListObject, String.format(" Bad network connection, exceeded max retry time 10 days. %s", remarks), 3, 1);
            } else {
                remarks = String.format(" Bad network connection, %d time(s) tried. %s", result.getLastFailObject().getRetryCount(), remarks);
                result.setBusinessCode(ResultCode.SDK_DOWNLOAD_IOEXCEPTION.getCode());
                updateBatchList = this.getUpdateBatchBody(paramListObject, remarks, 0, 0);
            }
        } else {
            updateBatchList = remarks != null ? this.getUpdateBatchBody(paramListObject, remarks, 3, 1) : this.getUpdateBatchBody(paramListObject, remarks, 2, 0);
        }
        return this.updateDownloadStatusBatch(updateBatchList);
    }

    private List<UpdateActionObject> getUpdateBatchBody(ParamListObject paramListObject, String remarks, int status, int errorCode) {
        ArrayList<UpdateActionObject> updateActionObjectList = new ArrayList<UpdateActionObject>();
        for (ParamObject paramObject : paramListObject.getList()) {
            UpdateActionObject updateActionObject = new UpdateActionObject();
            updateActionObject.setActionId(paramObject.getActionId());
            updateActionObject.setStatus(status);
            updateActionObject.setErrorCode(errorCode);
            updateActionObject.setRemarks(remarks);
            updateActionObjectList.add(updateActionObject);
        }
        return updateActionObjectList;
    }

    public HashMap<String, String> parseDownloadParamXml(File file) throws ParseXMLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (file != null) {
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(file);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    resultMap.put(element.getName(), element.getText());
                }
            }
            catch (Exception e) {
                throw new ParseXMLException(e);
            }
        } else {
            this.logger.info("parseDownloadParamXml: file is null, please make sure the file is correct.");
        }
        return resultMap;
    }

    public LinkedHashMap<String, String> parseDownloadParamJsonWithOrder(File file) throws JsonParseException {
        if (file != null) {
            String fileString = null;
            try {
                fileString = FileUtils.readFileToString((File)file);
                if (fileString != null) {
                    Gson gson = new Gson();
                    Type type = new TypeToken<LinkedHashMap<String, String>>(){}.getType();
                    return (LinkedHashMap)gson.fromJson(fileString, type);
                }
            }
            catch (Exception e) {
                this.logger.error("Read file error", (Throwable)e);
                throw new JsonParseException(e.getMessage());
            }
        }
        return null;
    }

    public LinkedHashMap<String, String> parseDownloadParamXmlWithOrder(File file) throws ParseXMLException {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        if (file != null) {
            try {
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(file);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    resultMap.put(element.getName(), element.getText());
                }
            }
            catch (Exception e) {
                throw new ParseXMLException(e);
            }
        } else {
            this.logger.info("parseDownloadParamXmlWithOrder: file is null, please make sure the file is correct.");
        }
        return resultMap;
    }
}

