/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.check;

import com.pax.market.api.sdk.java.api.update.UpdateApi;
import com.pax.market.api.sdk.java.base.api.BaseApi;
import com.pax.market.api.sdk.java.base.dto.ServiceAvailableObject;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckServiceApi
extends BaseApi {
    private final Logger logger = LoggerFactory.getLogger((String)UpdateApi.class.getSimpleName());
    protected static final String checkServiceUrl = "v1/3rdApps/service/{serviceType}/usable";

    public CheckServiceApi(String baseUrl, String appKey, String appSecret, String terminalSN) {
        super(baseUrl, appKey, appSecret, terminalSN);
    }

    public void setBaseUrl(String baseUrl) {
        super.getDefaultClient().setBaseUrl(baseUrl);
    }

    public ServiceAvailableObject checkServiceAvailable(ServiceType serviceType) {
        String replacedUrl = checkServiceUrl.replace("{serviceType}", serviceType.getValue());
        this.logger.info("checkServiceUrl >>> " + replacedUrl);
        SdkRequest request = new SdkRequest(replacedUrl);
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        return JsonUtils.fromJson(this.call(request), ServiceAvailableObject.class);
    }

    public static enum ServiceType {
        LAUNCHER_UP("launcherup");

        private final String value;

        private ServiceType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

