/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.terminalFirmware;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Response;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.terminalFirmware.dto.DisablePushFirmwareTask;
import com.pax.market.api.sdk.java.api.terminalFirmware.dto.PushFirmware2TerminalRequest;
import com.pax.market.api.sdk.java.api.terminalFirmware.dto.PushFirmwareTaskDTO;
import com.pax.market.api.sdk.java.api.terminalFirmware.dto.PushFirmwareTaskPageResponse;
import com.pax.market.api.sdk.java.api.terminalFirmware.dto.PushFirmwareTaskResponse;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalFirmwareApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalFirmwareApi.class);
    private static final String CREATE_TERMINAL_FIRMWARE_URL = "/v1/3rdsys/terminalFirmwares";
    private static final String SEARCH_TERMINAL_FIRMWARE_LIST_URL = "/v1/3rdsys/terminalFirmwares";
    private static final String GET_TERMINAL_FIRMWARE_URL = "/v1/3rdsys/terminalFirmwares/{terminalFirmwareId}";
    private static final String SUSPEND_TERMINAL_FIRMWARE_URL = "/v1/3rdsys/terminalFirmwares/suspend";

    public TerminalFirmwareApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public TerminalFirmwareApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<PushFirmwareTaskDTO> pushFirmware2Terminal(PushFirmware2TerminalRequest pushFirmware2TerminalRequest) {
        List<String> validationErrs = this.validateCreateTerminalFirmware(pushFirmware2TerminalRequest);
        if (validationErrs.size() > 0) {
            return new Result<PushFirmwareTaskDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalFirmwares");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)pushFirmware2TerminalRequest, PushFirmware2TerminalRequest.class));
        Response response = EnhancedJsonUtils.fromJson(client.execute(request), Response.class);
        Result<PushFirmwareTaskDTO> result = new Result<PushFirmwareTaskDTO>(response);
        return result;
    }

    public Result<PushFirmwareTaskDTO> searchPushFirmwareTasks(int pageNo, int pageSize, BaseThirdPartySysApi.SearchOrderBy orderBy, String terminalTid, String fmName, BaseThirdPartySysApi.PushStatus status, String serialNo) {
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val());
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalFirmwares", page);
        request.addRequestParam("terminalTid", terminalTid);
        request.addRequestParam("serialNo", serialNo);
        request.addRequestParam("fmName", fmName);
        if (status != null) {
            request.addRequestParam("status", status.val());
        }
        PushFirmwareTaskPageResponse pageResponse = EnhancedJsonUtils.fromJson(client.execute(request), PushFirmwareTaskPageResponse.class);
        Result<PushFirmwareTaskDTO> result = new Result<PushFirmwareTaskDTO>(pageResponse);
        return result;
    }

    public Result<PushFirmwareTaskDTO> searchPushFirmwareTasks(int pageNo, int pageSize, BaseThirdPartySysApi.SearchOrderBy orderBy, String terminalTid, String fmName, BaseThirdPartySysApi.PushStatus status) {
        logger.debug("terminalTid=" + terminalTid);
        List<String> validationErrs = TerminalFirmwareApi.validateStr(terminalTid, "parameter.searchPushFirmwareTasks.terminalTid.empty");
        if (validationErrs.size() > 0) {
            return new Result<PushFirmwareTaskDTO>(validationErrs);
        }
        return this.searchPushFirmwareTasks(pageNo, pageSize, orderBy, terminalTid, fmName, status, null);
    }

    public Result<PushFirmwareTaskDTO> getPushFirmwareTask(Long pushFirmwareTaskId) {
        logger.debug("pushFirmwareTaskId=" + pushFirmwareTaskId);
        List<String> validationErrs = TerminalFirmwareApi.validateId(pushFirmwareTaskId, "parameter.pushFirmwareTaskId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<PushFirmwareTaskDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(GET_TERMINAL_FIRMWARE_URL.replace("{terminalFirmwareId}", pushFirmwareTaskId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        PushFirmwareTaskResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), PushFirmwareTaskResponse.class);
        Result<PushFirmwareTaskDTO> result = new Result<PushFirmwareTaskDTO>(resp);
        return result;
    }

    public Result<String> disablePushFirmwareTask(DisablePushFirmwareTask disablePushFirmwareTask) {
        List<String> validationErrs = this.validateDisablePushFirmware(disablePushFirmwareTask);
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(SUSPEND_TERMINAL_FIRMWARE_URL);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)disablePushFirmwareTask, DisablePushFirmwareTask.class));
        Response resp = EnhancedJsonUtils.fromJson(client.execute(request), Response.class);
        Result<String> result = new Result<String>(resp);
        return result;
    }

    private List<String> validateCreateTerminalFirmware(PushFirmware2TerminalRequest createTerminalFirmwareRequest) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (createTerminalFirmwareRequest == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.createTerminalFirmwareRequest.null"));
        } else {
            validationErrs.addAll(TerminalFirmwareApi.validate(createTerminalFirmwareRequest));
            if (StringUtils.isEmpty(createTerminalFirmwareRequest.getSerialNo()) && StringUtils.isEmpty(createTerminalFirmwareRequest.getTid())) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.createTerminalFirmwareRequest.sn.tid.empty"));
            }
        }
        return validationErrs;
    }

    private List<String> validateDisablePushFirmware(DisablePushFirmwareTask disablePushFirmwareTask) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (disablePushFirmwareTask == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.disablePushFirmwareTask.null"));
        } else {
            validationErrs.addAll(TerminalFirmwareApi.validate(disablePushFirmwareTask));
            if (StringUtils.isEmpty(disablePushFirmwareTask.getSerialNo()) && StringUtils.isEmpty(disablePushFirmwareTask.getTid())) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.disablePushFirmwareTask.sn.tid.empty"));
            }
        }
        return validationErrs;
    }
}

