/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.terminalApk;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Response;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.terminalApk.dto.CreateTerminalApkRequest;
import com.pax.market.api.sdk.java.api.terminalApk.dto.FileParameter;
import com.pax.market.api.sdk.java.api.terminalApk.dto.TerminalApkDTO;
import com.pax.market.api.sdk.java.api.terminalApk.dto.TerminalApkPageResponse;
import com.pax.market.api.sdk.java.api.terminalApk.dto.TerminalApkResponse;
import com.pax.market.api.sdk.java.api.terminalApk.dto.UpdateTerminalApkRequest;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.FileUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalApkApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalApkApi.class);
    private static final String SEARCH_TERMINAL_APK_LIST_URL = "/v1/3rdsys/terminalApks";
    private static final String CREATE_TERMINAL_APK_URL = "/v1/3rdsys/terminalApks";
    private static final String GET_TERMINAL_APK_URL = "/v1/3rdsys/terminalApks/{terminalApkId}";
    private static final String SUSPEND_TERMINAL_APK_URL = "/v1/3rdsys/terminalApks/suspend";
    private static final String UNINSTALL_TERMINAL_APK_URL = "/v1/3rdsys/terminalApks/uninstall";
    private static final int MAX_FILE_TYPE_PARAMETER_COUNTER = 10;
    private static final int MAX_FILE_TYPE_PARAMETER_SIZE = 500;
    private static final String TEMPLATE_NAME_DELIMITER = "|";
    private static final int MAX_TEMPLATE_SIZE = 10;

    public TerminalApkApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public TerminalApkApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<TerminalApkDTO> searchTerminalApk(int pageNo, int pageSize, SearchOrderBy orderBy, String terminalTid, String appPackageName, PushStatus status) {
        List<String> validationErrs;
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val());
        }
        if ((validationErrs = TerminalApkApi.validate(page)).size() > 0) {
            return new Result<TerminalApkDTO>(validationErrs);
        }
        if (StringUtils.isEmpty(terminalTid)) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.searchTerminalApk.terminalTid.empty"));
            return new Result<TerminalApkDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalApks", page);
        request.addRequestParam("terminalTid", terminalTid);
        request.addRequestParam("appPackageName", appPackageName);
        if (status != null) {
            request.addRequestParam("status", status.val());
        }
        TerminalApkPageResponse pageResponse = EnhancedJsonUtils.fromJson(client.execute(request), TerminalApkPageResponse.class);
        Result<TerminalApkDTO> result = new Result<TerminalApkDTO>(pageResponse);
        return result;
    }

    public Result<TerminalApkDTO> createTerminalApk(CreateTerminalApkRequest createTerminalApkRequest) {
        List<String> validationErrs = this.validateCreateTerminalApk(createTerminalApkRequest);
        if (createTerminalApkRequest.getBase64FileParameters() != null && !createTerminalApkRequest.getBase64FileParameters().isEmpty()) {
            if (createTerminalApkRequest.getBase64FileParameters().size() > 10) {
                validationErrs.add(TerminalApkApi.getMessage("parametersBase64FileParameters.over.maxCounter"));
            }
            for (FileParameter fileParameter : createTerminalApkRequest.getBase64FileParameters()) {
                if (FileUtils.getBase64FileSizeKB(fileParameter.getFileData()) <= 500) continue;
                validationErrs.add(TerminalApkApi.getMessage("parametersBase64FileParameters.over.maxSize"));
                break;
            }
        }
        if (validationErrs.size() > 0) {
            return new Result<TerminalApkDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalApks");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)createTerminalApkRequest, CreateTerminalApkRequest.class));
        TerminalApkResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalApkResponse.class);
        Result<TerminalApkDTO> result = new Result<TerminalApkDTO>(resp);
        return result;
    }

    public Result<TerminalApkDTO> getTerminalApk(Long terminalApkId) {
        return this.getTerminalApk(terminalApkId, null);
    }

    public Result<TerminalApkDTO> getTerminalApk(Long terminalApkId, List<String> pidList) {
        logger.debug("terminalApkId=" + terminalApkId);
        List<String> validationErrs = TerminalApkApi.validateId(terminalApkId, "parameter.terminalApkId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<TerminalApkDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(GET_TERMINAL_APK_URL.replace("{terminalApkId}", terminalApkId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (pidList != null) {
            request.addRequestParam("pidList", StringUtils.join(pidList, (String)","));
        }
        TerminalApkResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalApkResponse.class);
        Result<TerminalApkDTO> result = new Result<TerminalApkDTO>(resp);
        return result;
    }

    public Result<String> disableApkPush(UpdateTerminalApkRequest disableTerminalApkRequest) {
        List<String> validationErrs = this.validateSuspendTerminalApk(disableTerminalApkRequest);
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(SUSPEND_TERMINAL_APK_URL);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)disableTerminalApkRequest, UpdateTerminalApkRequest.class));
        Response resp = EnhancedJsonUtils.fromJson(client.execute(request), Response.class);
        Result<String> result = new Result<String>(resp);
        return result;
    }

    public Result<String> uninstallApk(UpdateTerminalApkRequest uninstallApkRequest) {
        List<String> validationErrs = this.validateUninstallTerminalApk(uninstallApkRequest);
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(UNINSTALL_TERMINAL_APK_URL);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)uninstallApkRequest, UpdateTerminalApkRequest.class));
        Response resp = EnhancedJsonUtils.fromJson(client.execute(request), Response.class);
        Result<String> result = new Result<String>(resp);
        return result;
    }

    private List<String> validateCreateTerminalApk(CreateTerminalApkRequest createTerminalApkRequest) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (createTerminalApkRequest == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.createTerminalApkRequest.null"));
        } else {
            validationErrs.addAll(TerminalApkApi.validate(createTerminalApkRequest));
            if (StringUtils.isEmpty(createTerminalApkRequest.getSerialNo()) && StringUtils.isEmpty(createTerminalApkRequest.getTid())) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.createTerminalApkRequest.sn.tid.empty"));
            }
            if (!StringUtils.isEmpty(createTerminalApkRequest.getTemplateName()) && createTerminalApkRequest.getTemplateName().split("\\|").length > 10) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.createTerminalApkRequest.template.name.toolong"));
            }
        }
        return validationErrs;
    }

    private List<String> validateSuspendTerminalApk(UpdateTerminalApkRequest suspendTerminalApkRequest) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (suspendTerminalApkRequest == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.suspendTerminalApkRequest.null"));
        } else {
            validationErrs.addAll(TerminalApkApi.validate(suspendTerminalApkRequest));
            if (StringUtils.isEmpty(suspendTerminalApkRequest.getSerialNo()) && StringUtils.isEmpty(suspendTerminalApkRequest.getTid())) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.suspendTerminalApkRequest.sn.tid.empty"));
            }
        }
        return validationErrs;
    }

    private List<String> validateUninstallTerminalApk(UpdateTerminalApkRequest uninstallTerminalApkRequest) {
        ArrayList<String> validationErrs = new ArrayList<String>();
        if (uninstallTerminalApkRequest == null) {
            validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.uninstallTerminalApkRequest.null"));
        } else {
            validationErrs.addAll(TerminalApkApi.validate(uninstallTerminalApkRequest));
            if (StringUtils.isEmpty(uninstallTerminalApkRequest.getSerialNo()) && StringUtils.isEmpty(uninstallTerminalApkRequest.getTid())) {
                validationErrs.add(BaseThirdPartySysApi.getMessage("parameter.uninstallTerminalApkRequest.sn.tid.empty"));
            }
        }
        return validationErrs;
    }

    public static enum PushStatus {
        Active("A"),
        Suspend("S");

        private String val;

        private PushStatus(String status) {
            this.val = status;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum SearchOrderBy {
        CreatedDate_desc("a.created_date DESC"),
        CreatedDate_asc("a.created_date ASC");

        private String val;

        private SearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

