/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.base.dto;

import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageInfo;
import com.pax.market.api.sdk.java.api.base.dto.PageResponse;
import com.pax.market.api.sdk.java.api.base.dto.Response;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class Result<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 6318528536528828759L;
    private int businessCode;
    private String message;
    private List<String> validationErrors;
    private T data;
    private String rateLimit;
    private String rateLimitRemain;
    private String rateLimitReset;
    private PageInfo<T> pageInfo;

    public Result() {
    }

    public Result(List<String> errors) {
        this.businessCode = -1;
        this.validationErrors = errors;
    }

    public Result(Response<T> response) {
        this.businessCode = response.getBusinessCode();
        this.message = response.getMessage();
        this.data = response.getData();
        this.rateLimit = response.getRateLimit();
        this.rateLimitRemain = response.getRateLimitRemain();
        this.rateLimitReset = response.getRateLimitReset();
    }

    public Result(PageResponse<T> response) {
        this.businessCode = response.getBusinessCode();
        this.message = response.getMessage();
        PageInfo<T> pageInfo = new PageInfo<T>();
        pageInfo.setDataSet(response.getDataset());
        pageInfo.setHasNext(response.isHasNext());
        pageInfo.setLimit(response.getLimit());
        pageInfo.setOrderBy(response.getOrderBy());
        pageInfo.setPageNo(response.getPageNo());
        pageInfo.setTotalCount(response.getTotalCount());
        this.rateLimit = response.getRateLimit();
        this.rateLimitRemain = response.getRateLimitRemain();
        this.rateLimitReset = response.getRateLimitReset();
        this.pageInfo = pageInfo;
    }

    public Result(EmptyResponse response) {
        if (response == null) {
            this.businessCode = 0;
        } else {
            this.businessCode = response.getBusinessCode();
            this.message = response.getMessage();
            this.data = null;
            this.rateLimit = response.getRateLimit();
            this.rateLimitRemain = response.getRateLimitRemain();
            this.rateLimitReset = response.getRateLimitReset();
        }
    }

    public int getBusinessCode() {
        return this.businessCode;
    }

    public void setBusinessCode(int businessCode) {
        this.businessCode = businessCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public PageInfo<T> getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo<T> pageInfo) {
        this.pageInfo = pageInfo;
    }

    public String getRateLimit() {
        return this.rateLimit;
    }

    public String getRateLimitRemain() {
        return this.rateLimitRemain;
    }

    public String getRateLimitReset() {
        return this.rateLimitReset;
    }

    public String toString() {
        return "Result [businessCode=" + this.businessCode + ", message=" + this.message + ", validationErrors=" + this.validationErrors + ", data=" + this.data + ", rateLimit=" + this.rateLimit + ", rateLimitRemain=" + this.rateLimitRemain + ", rateLimitReset=" + this.rateLimitReset + ", pageInfo=" + this.pageInfo + "]" + (this.rateLimitReset != null && this.rateLimitReset.trim().length() > 0 ? new Date(Long.parseLong(this.rateLimitReset)).toString() : "");
    }
}

