/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.terminalGroupApk;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.terminalApk.dto.FileParameter;
import com.pax.market.api.sdk.java.api.terminalGroupApk.dto.CreateTerminalGroupApkRequest;
import com.pax.market.api.sdk.java.api.terminalGroupApk.dto.SimpleTerminalGroupApkDTO;
import com.pax.market.api.sdk.java.api.terminalGroupApk.dto.TerminalGroupApkPageResponse;
import com.pax.market.api.sdk.java.api.terminalGroupApk.dto.TerminalGroupApkResponse;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.FileUtils;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalGroupApkApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalGroupApkApi.class);
    private static final String GET_TERMINAL_GROUP_APK_URL = "/v1/3rdsys/terminalGroupApks/{groupApkId}";
    private static final String SEARCH_TERMINAL_GROUP_APK_URL = "/v1/3rdsys/terminalGroupApks";
    private static final String CREATE_TERMINAL_GROUP_APK_URL = "/v1/3rdsys/terminalGroupApks";
    private static final String SUSPEND_TERMINAL_GROUP_APK_URL = "/v1/3rdsys/terminalGroupApks/{groupApkId}/suspend";
    private static final String DELETE_TERMINAL_GROUP_APK_URL = "/v1/3rdsys/terminalGroupApks/{groupApkId}";
    private static final int MAX_FILE_TYPE_PARAMETER_COUNTER = 10;
    private static final int MAX_FILE_TYPE_PARAMETER_SIZE = 500;

    public TerminalGroupApkApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public TerminalGroupApkApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<SimpleTerminalGroupApkDTO> getTerminalGroupApk(Long groupApkId) {
        return this.getTerminalGroupApk(groupApkId, null);
    }

    public Result<SimpleTerminalGroupApkDTO> getTerminalGroupApk(Long groupApkId, List<String> pidList) {
        logger.debug("groupApkId=" + groupApkId);
        List<String> validationErrs = TerminalGroupApkApi.validateId(groupApkId, "parameter.terminalGroupApkId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<SimpleTerminalGroupApkDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroupApks/{groupApkId}".replace("{groupApkId}", groupApkId.toString() + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (pidList != null) {
            request.addRequestParam("pidList", StringUtils.join(pidList, (String)","));
        }
        TerminalGroupApkResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupApkResponse.class);
        Result<SimpleTerminalGroupApkDTO> result = new Result<SimpleTerminalGroupApkDTO>(resp);
        return result;
    }

    public Result<SimpleTerminalGroupApkDTO> searchTerminalGroupApk(int pageNo, int pageSize, SearchOrderBy orderBy, Long groupId, Boolean pendingOnly, Boolean historyOnly, String keyWords) {
        logger.debug("groupId=" + groupId);
        List<String> validationErrId = TerminalGroupApkApi.validateId(groupId, "parameter.terminalGroupId.invalid");
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val());
        }
        List<String> validationErrs = TerminalGroupApkApi.validate(page);
        validationErrs.addAll(validationErrId);
        if (validationErrs.size() > 0) {
            return new Result<SimpleTerminalGroupApkDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalGroupApks", page);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (groupId != null) {
            request.addRequestParam("groupId", groupId.toString());
        }
        if (pendingOnly != null) {
            request.addRequestParam("pendingOnly", pendingOnly.toString());
        }
        if (historyOnly != null) {
            request.addRequestParam("historyOnly", historyOnly.toString());
        }
        if (keyWords != null) {
            request.addRequestParam("keyWords", keyWords);
        }
        TerminalGroupApkPageResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupApkPageResponse.class);
        Result<SimpleTerminalGroupApkDTO> result = new Result<SimpleTerminalGroupApkDTO>(resp);
        return result;
    }

    public Result<SimpleTerminalGroupApkDTO> createAndActiveGroupApk(CreateTerminalGroupApkRequest createRequest) {
        List<String> validationErrs = TerminalGroupApkApi.validateCreate(createRequest, "parameter.terminalGroupApkCreateRequest.null");
        if (createRequest.getBase64FileParameters() != null && !createRequest.getBase64FileParameters().isEmpty()) {
            if (createRequest.getBase64FileParameters().size() > 10) {
                validationErrs.add(TerminalGroupApkApi.getMessage("parametersBase64FileParameters.over.maxCounter"));
            }
            for (FileParameter fileParameter : createRequest.getBase64FileParameters()) {
                if (FileUtils.getBase64FileSizeKB(fileParameter.getFileData()) <= 500) continue;
                validationErrs.add(TerminalGroupApkApi.getMessage("parametersBase64FileParameters.over.maxSize"));
                break;
            }
        }
        if (validationErrs.size() > 0) {
            return new Result<SimpleTerminalGroupApkDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroupApks");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)createRequest, CreateTerminalGroupApkRequest.class));
        TerminalGroupApkResponse terminalGroupApkResponse = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupApkResponse.class);
        Result<SimpleTerminalGroupApkDTO> result = new Result<SimpleTerminalGroupApkDTO>(terminalGroupApkResponse);
        return result;
    }

    public Result<SimpleTerminalGroupApkDTO> suspendTerminalGroupApk(Long groupApkId) {
        logger.debug("groupApkId=" + groupApkId);
        List<String> validationErrs = TerminalGroupApkApi.validateId(groupApkId, "parameter.terminalGroupApkId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<SimpleTerminalGroupApkDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(SUSPEND_TERMINAL_GROUP_APK_URL.replace("{groupApkId}", groupApkId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        TerminalGroupApkResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupApkResponse.class);
        Result<SimpleTerminalGroupApkDTO> result = new Result<SimpleTerminalGroupApkDTO>(resp);
        return result;
    }

    public Result<String> deleteTerminalGroupApk(Long groupApkId) {
        logger.debug("groupApkId=" + groupApkId);
        List<String> validationErrs = TerminalGroupApkApi.validateId(groupApkId, "parameter.terminalGroupApkId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroupApks/{groupApkId}".replace("{groupApkId}", groupApkId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        return new Result<String>(emptyResponse);
    }

    public static enum SearchOrderBy {
        CreatedDate_desc("a.created_date DESC"),
        CreatedDate_asc("a.created_date ASC");

        private String val;

        private SearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

