/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.terminalGroup;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.terminal.TerminalApi;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.CreateTerminalGroupRequest;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.SimpleTerminalDTO;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.SimpleTerminalPageResponse;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.TerminalGroupDTO;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.TerminalGroupPageResponse;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.TerminalGroupRequest;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.TerminalGroupResponse;
import com.pax.market.api.sdk.java.api.terminalGroup.dto.UpdateTerminalGroupRequest;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalGroupApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger(TerminalGroupApi.class);
    private static final String GET_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}";
    private static final String SEARCH_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups";
    private static final String CREATE_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups";
    private static final String SEARCH_TERMINAL_URL = "/v1/3rdsys/terminalGroups/terminal";
    private static final String UPDATE_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}";
    private static final String ACTIVE_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}/active";
    private static final String DISABLE_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}/disable";
    private static final String DELETE_TERMINAL_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}";
    private static final String SEARCH_TERMINAL_IN_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}/terminals";
    private static final String ADD_TERMINAL_IN_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}/terminals";
    private static final String REMOVE_TERMINAL_OUT_GROUP_URL = "/v1/3rdsys/terminalGroups/{groupId}/terminals";

    public TerminalGroupApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public TerminalGroupApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<TerminalGroupDTO> searchTerminalGroup(int pageNo, int pageSize, TerminalGroupSearchOrderBy orderBy, TerminalGroupStatus status, String name, String resellerNames, String modelNames, Boolean isDynamic) {
        List<String> validationErrs;
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val());
        }
        if ((validationErrs = TerminalGroupApi.validate(page)).size() > 0) {
            return new Result<TerminalGroupDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalGroups", page);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (status != null) {
            request.addRequestParam("status", status.val());
        }
        if (modelNames != null) {
            request.addRequestParam("modelNames", modelNames);
        }
        if (resellerNames != null) {
            request.addRequestParam("resellerNames", resellerNames);
        }
        if (name != null) {
            request.addRequestParam("name", name);
        }
        if (isDynamic != null) {
            request.addRequestParam("isDynamic", isDynamic.toString());
        }
        TerminalGroupPageResponse terminalGroupPageResponse = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupPageResponse.class);
        Result<TerminalGroupDTO> result = new Result<TerminalGroupDTO>(terminalGroupPageResponse);
        return result;
    }

    public Result<TerminalGroupDTO> getTerminalGroup(Long groupId) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<TerminalGroupDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups/{groupId}".replace("{groupId}", groupId.toString() + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        TerminalGroupResponse resp = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupResponse.class);
        Result<TerminalGroupDTO> result = new Result<TerminalGroupDTO>(resp);
        return result;
    }

    public Result<TerminalGroupDTO> createTerminalGroup(CreateTerminalGroupRequest createRequest) {
        List<String> validationErrs = TerminalGroupApi.validateCreate(createRequest, "parameter.terminalGroupCreateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<TerminalGroupDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)createRequest, CreateTerminalGroupRequest.class));
        TerminalGroupResponse terminalGroupResponse = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupResponse.class);
        Result<TerminalGroupDTO> result = new Result<TerminalGroupDTO>(terminalGroupResponse);
        return result;
    }

    public Result<SimpleTerminalDTO> searchTerminal(int pageNo, int pageSize, TerminalApi.TerminalSearchOrderBy orderBy, TerminalApi.TerminalStatus status, String modelName, String resellerName, String serialNo, String excludeGroupId) {
        List<String> validationErrs;
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val());
        }
        if ((validationErrs = TerminalGroupApi.validate(page)).size() > 0) {
            return new Result<SimpleTerminalDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest(SEARCH_TERMINAL_URL, page);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (status != null) {
            request.addRequestParam("status", status.val());
        }
        if (modelName != null) {
            request.addRequestParam("modelName", modelName);
        }
        if (resellerName != null) {
            request.addRequestParam("resellerName", resellerName);
        }
        if (serialNo != null) {
            request.addRequestParam("serialNo", serialNo);
        }
        if (excludeGroupId != null) {
            request.addRequestParam("excludeGroupId", excludeGroupId);
        }
        SimpleTerminalPageResponse terminalPageResponse = EnhancedJsonUtils.fromJson(client.execute(request), SimpleTerminalPageResponse.class);
        Result<SimpleTerminalDTO> result = new Result<SimpleTerminalDTO>(terminalPageResponse);
        return result;
    }

    public Result<TerminalGroupDTO> updateTerminalGroup(Long groupId, UpdateTerminalGroupRequest updateRequest) {
        List<String> validationErrs = TerminalGroupApi.validateUpdate(groupId, updateRequest, "parameter.terminalGroupId.invalid", "parameter.terminalGroupUpdateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<TerminalGroupDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups/{groupId}".replace("{groupId}", groupId.toString() + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)updateRequest, UpdateTerminalGroupRequest.class));
        TerminalGroupResponse terminalGroupResponse = EnhancedJsonUtils.fromJson(client.execute(request), TerminalGroupResponse.class);
        Result<TerminalGroupDTO> result = new Result<TerminalGroupDTO>(terminalGroupResponse);
        return result;
    }

    public Result<String> activeGroup(Long groupId) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(ACTIVE_TERMINAL_GROUP_URL.replace("{groupId}", groupId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        return this.emptyResult(client, request);
    }

    public Result<String> disableGroup(Long groupId) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(DISABLE_TERMINAL_GROUP_URL.replace("{groupId}", groupId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        return this.emptyResult(client, request);
    }

    public Result<String> deleteGroup(Long groupId) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups/{groupId}".replace("{groupId}", groupId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        return this.emptyResult(client, request);
    }

    public Result<SimpleTerminalDTO> searchTerminalsInGroup(int pageNo, int pageSize, TerminalApi.TerminalSearchOrderBy orderBy, Long groupId, String serialNo, String merchantNames) {
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            if (orderBy == TerminalApi.TerminalSearchOrderBy.SerialNo) {
                page.setOrderBy("a.serial_no ASC, a.id ASC");
            } else {
                page.setOrderBy(orderBy.val());
            }
        }
        List<String> validationErrs = TerminalGroupApi.validate(page);
        if (groupId == null) {
            validationErrs.add(TerminalGroupApi.getMessage("parameter.groupId.null"));
        }
        if (validationErrs.size() > 0) {
            return new Result<SimpleTerminalDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/terminalGroups/{groupId}/terminals".replace("{groupId}", groupId.toString()), page);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        if (serialNo != null) {
            request.addRequestParam("serialNo", serialNo);
        }
        if (merchantNames != null) {
            request.addRequestParam("merchantNames", merchantNames);
        }
        SimpleTerminalPageResponse terminalPageResponse = EnhancedJsonUtils.fromJson(client.execute(request), SimpleTerminalPageResponse.class);
        Result<SimpleTerminalDTO> result = new Result<SimpleTerminalDTO>(terminalPageResponse);
        return result;
    }

    public Result<String> addTerminalToGroup(Long groupId, Set<Long> terminalIds) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups/{groupId}/terminals".replace("{groupId}", groupId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson(terminalIds, Set.class));
        return this.emptyResult(client, request);
    }

    public Result<String> removeTerminalOutGroup(Long groupId, Set<Long> terminalIds) {
        List<String> validationErrs = this.validateGroupId(groupId);
        if (!validationErrs.isEmpty()) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/terminalGroups/{groupId}/terminals".replace("{groupId}", groupId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson(terminalIds, TerminalGroupRequest.class));
        return this.emptyResult(client, request);
    }

    private List<String> validateGroupId(Long groupId) {
        logger.debug("groupId=" + groupId);
        List<String> validationErrs = TerminalGroupApi.validateId(groupId, "parameter.terminalGroupId.invalid");
        return validationErrs;
    }

    private Result<String> emptyResult(ThirdPartySysApiClient client, SdkRequest request) {
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        return new Result<String>(emptyResponse);
    }

    public static enum TerminalGroupStatus {
        Pending("P"),
        Active("A"),
        Suspend("S");

        private String val;

        private TerminalGroupStatus(String status) {
            this.val = status;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum TerminalGroupSearchOrderBy {
        Name("name"),
        CreatedDate_desc("createdDate DESC"),
        CreatedDate_asc("createdDate ASC");

        private String val;

        private TerminalGroupSearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }
}

