/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.merchant;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.BaseThirdPartySysApi;
import com.pax.market.api.sdk.java.api.base.dto.EmptyResponse;
import com.pax.market.api.sdk.java.api.base.dto.PageRequestDTO;
import com.pax.market.api.sdk.java.api.base.dto.Result;
import com.pax.market.api.sdk.java.api.base.request.SdkRequest;
import com.pax.market.api.sdk.java.api.client.ThirdPartySysApiClient;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantCreateRequest;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantDTO;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantPageDTO;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantPageResponse;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantResponseDTO;
import com.pax.market.api.sdk.java.api.merchant.dto.MerchantUpdateRequest;
import com.pax.market.api.sdk.java.api.util.EnhancedJsonUtils;
import com.pax.market.api.sdk.java.api.util.MessageBoudleUtil;
import com.pax.market.api.sdk.java.api.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantApi
extends BaseThirdPartySysApi {
    private static final Logger logger = LoggerFactory.getLogger((String)MerchantApi.class.getSimpleName());
    private static final String SEARCH_MERCHANT_URL = "/v1/3rdsys/merchants";
    private static final String GET_MERCHANT_URL = "/v1/3rdsys/merchants/{merchantId}";
    private static final String CREATE_MERCHANT_URL = "/v1/3rdsys/merchants";
    private static final String UPDATE_MERCHANT_URL = "/v1/3rdsys/merchants/{merchantId}";
    private static final String ACTIVATE_MERCHANT_URL = "/v1/3rdsys/merchants/{merchantId}/active";
    private static final String DISABLE_MERCHANT_URL = "/v1/3rdsys/merchants/{merchantId}/disable";
    private static final String DELETE_MERCHANT_URL = "/v1/3rdsys/merchants/{merchantId}";
    private static final String REPLACE_MERCHANT_EMAIL_URL = "/v1/3rdsys/merchants/{merchantId}/replaceEmail";

    public MerchantApi(String baseUrl, String apiKey, String apiSecret) {
        super(baseUrl, apiKey, apiSecret);
    }

    public MerchantApi(String baseUrl, String apiKey, String apiSecret, Locale locale) {
        super(baseUrl, apiKey, apiSecret, locale);
    }

    public Result<MerchantPageDTO> searchMerchant(int pageNo, int pageSize, MerchantSearchOrderBy orderBy, String name, MerchantStatus status) {
        List<String> validationErrs;
        logger.debug("name=" + name + "|status=" + (Object)((Object)status));
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        PageRequestDTO page = new PageRequestDTO();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        if (orderBy != null) {
            page.setOrderBy(orderBy.val);
        }
        if ((validationErrs = MerchantApi.validate(page)).size() > 0) {
            return new Result<MerchantPageDTO>(validationErrs);
        }
        SdkRequest request = this.getPageRequest("/v1/3rdsys/merchants", page);
        request.addRequestParam("name", name);
        if (status != null) {
            request.addRequestParam("status", status.val);
        }
        MerchantPageResponse merchantPageDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantPageResponse.class);
        Result<MerchantPageDTO> result = new Result<MerchantPageDTO>(merchantPageDTO);
        return result;
    }

    public Result<MerchantDTO> getMerchant(Long merchantId) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateId(merchantId, "parameter.merchantId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<MerchantDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchants/{merchantId}".replace("{merchantId}", merchantId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        MerchantResponseDTO merchantResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantResponseDTO.class);
        Result<MerchantDTO> result = new Result<MerchantDTO>(merchantResponseDTO);
        return result;
    }

    public Result<MerchantDTO> createMerchant(MerchantCreateRequest merchantCreateRequest) {
        List<String> validationErrs = MerchantApi.validateCreate(merchantCreateRequest, "parameter.merchantCreateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<MerchantDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchants");
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)merchantCreateRequest, MerchantCreateRequest.class));
        MerchantResponseDTO merchantResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantResponseDTO.class);
        Result<MerchantDTO> result = new Result<MerchantDTO>(merchantResponseDTO);
        return result;
    }

    public Result<MerchantDTO> updateMerchant(Long merchantId, MerchantUpdateRequest merchantUpdateRequest) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateUpdate(merchantId, merchantUpdateRequest, "parameter.merchantId.invalid", "parameter.merchantUpdateRequest.null");
        if (validationErrs.size() > 0) {
            return new Result<MerchantDTO>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchants/{merchantId}".replace("{merchantId}", merchantId + ""));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestBody(new Gson().toJson((Object)merchantUpdateRequest, MerchantUpdateRequest.class));
        MerchantResponseDTO merchantResponseDTO = EnhancedJsonUtils.fromJson(client.execute(request), MerchantResponseDTO.class);
        Result<MerchantDTO> result = new Result<MerchantDTO>(merchantResponseDTO);
        return result;
    }

    public Result<String> activateMerchant(Long merchantId) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateId(merchantId, "parameter.merchantId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(ACTIVATE_MERCHANT_URL.replace("{merchantId}", merchantId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> disableMerchant(Long merchantId) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateId(merchantId, "parameter.merchantId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(DISABLE_MERCHANT_URL.replace("{merchantId}", merchantId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.PUT);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> deleteMerchant(Long merchantId) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateId(merchantId, "parameter.merchantId.invalid");
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest("/v1/3rdsys/merchants/{merchantId}".replace("{merchantId}", merchantId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.DELETE);
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public Result<String> replaceMerchantEmail(Long merchantId, String email, boolean createUser) {
        logger.debug("merchantId=" + merchantId);
        List<String> validationErrs = MerchantApi.validateId(merchantId, "parameter.merchantId.invalid");
        if (!StringUtils.isValidEmailAddress(email)) {
            validationErrs.add(MessageBoudleUtil.getMessage("parameter.email.invalid", Locale.getDefault()));
        }
        if (email != null && email.length() > 255) {
            validationErrs.add(MessageBoudleUtil.getMessage("parameter.email.toolong", Locale.getDefault()));
        }
        if (validationErrs.size() > 0) {
            return new Result<String>(validationErrs);
        }
        ThirdPartySysApiClient client = new ThirdPartySysApiClient(this.getBaseUrl(), this.getApiKey(), this.getApiSecret());
        SdkRequest request = this.createSdkRequest(REPLACE_MERCHANT_EMAIL_URL.replace("{merchantId}", merchantId.toString()));
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
        requestBodyMap.put("email", email);
        requestBodyMap.put("createUser", createUser);
        request.setRequestBody(new Gson().toJson(requestBodyMap, Map.class));
        EmptyResponse emptyResponse = EnhancedJsonUtils.fromJson(client.execute(request), EmptyResponse.class);
        Result<String> result = new Result<String>(emptyResponse);
        return result;
    }

    public static enum MerchantSearchOrderBy {
        Name("name"),
        Phone("phone"),
        Contact("contact");

        private String val;

        private MerchantSearchOrderBy(String orderBy) {
            this.val = orderBy;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum MerchantStatus {
        Active("A"),
        Inactive("P"),
        Suspend("S");

        private String val;

        private MerchantStatus(String status) {
            this.val = status;
        }

        public String val() {
            return this.val;
        }
    }
}

