/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.base.request;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkRequest {
    private static final Logger logger = LoggerFactory.getLogger(SdkRequest.class);
    protected RequestMethod requestMethod = RequestMethod.GET;
    protected String requestMappingUrl;
    protected Map<String, String> headerMap;
    protected Map<String, String> requestParams;
    protected Long timestamp;
    protected String requestBody;
    protected String saveFilePath;
    protected boolean compressData = false;

    public SdkRequest() {
    }

    public SdkRequest(String requestMappingUrl) {
        this.requestMappingUrl = requestMappingUrl;
    }

    public SdkRequest(String requestMappingUrl, RequestMethod requestMethod) {
        this(requestMappingUrl);
        this.requestMethod = requestMethod;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getRequestMappingUrl() {
        return this.requestMappingUrl;
    }

    public void setRequestMappingUrl(String requestMappingUrl) {
        this.requestMappingUrl = requestMappingUrl;
    }

    public Map<String, String> getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, String>();
        }
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public void addHeader(String key, String value) {
        this.getHeaderMap().put(key, value);
    }

    public Map<String, String> getRequestParams() {
        if (this.requestParams == null) {
            this.requestParams = new HashMap<String, String>();
        }
        return this.requestParams;
    }

    public void setRequestParams(Map<String, String> requestParams) {
        this.requestParams = requestParams;
    }

    public void addRequestParam(String key, String value) {
        this.getRequestParams().put(key, value);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        logger.debug("Request body is {}", (Object)requestBody);
        this.requestBody = requestBody;
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    public boolean isCompressData() {
        return this.compressData;
    }

    public void setCompressData(boolean compressData) {
        this.compressData = compressData;
    }

    public static enum RequestMethod {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE");

        private String value;

        private RequestMethod(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

