/*
 * *******************************************************************************
 * COPYRIGHT
 *               PAX TECHNOLOGY, Inc. PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with PAX  Technology, Inc. and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *
 *      Copyright (C) 2017 PAX Technology, Inc. All rights reserved.
 * *******************************************************************************
 */
package com.pax.market.api.sdk.java.api.constant;

/**
 * Created by fanjun on 2016/11/9.
 */
public class Constants {

    /**
     * 协议入参共享参数
     */
    public static final String APP_KEY = "appKey";
    /**
     * The constant TIMESTAMP.
     */
    public static final String TIMESTAMP = "timestamp";
    /**
     * The constant SIGN_METHOD.
     */
    public static final String SIGN_METHOD = "signMethod";
    /**
     * The constant SIGNATURE.
     */
    public static final String SIGNATURE = "signature";


    /**
     * TOP默认时间格式
     */
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static final String TIMEZONE_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss Z";

    /**
     * UTF-8字符集
     */
    public static final String CHARSET_UTF8 = "UTF-8";

    /**
     * 响应编码
     */
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    /**
     * The constant CONTENT_ENCODING.
     */
    public static final String CONTENT_ENCODING = "Content-Encoding";
    /**
     * The constant CONTENT_ENCODING_GZIP.
     */
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    /**
     * The constant PARAM_DATA.
     */
    public static final String PARAM_DATA = "data";

    /**
     * 默认媒体类型
     */
    public static final String MIME_TYPE_DEFAULT = "application/octet-stream";
    /**
     * The constant ACCESS_LANGUAGE.
     */
    public static final String ACCESS_LANGUAGE = "Accept-Language";

    /**
     * MD5签名方式
     */
    public static final String SIGN_METHOD_MD5 = "md5";
    /**
     * HMAC签名方式
     */
    public static final String SIGN_METHOD_HMAC = "hmac";

    /**
     * The constant CONTENT_TYPE.
     */
    public static final String CONTENT_TYPE = "Content-Type";
    /**
     * The constant CONTENT_TYPE_JSON.
     */
    public static final String CONTENT_TYPE_JSON = "application/json;charset=utf-8";

    /**
     * The constant REQ_HEADER_DOMAIN.
     */
    public static final String REQ_HEADER_DOMAIN = "X-Market-Domain";
    /**
     * The constant REQ_HEADER_SN.
     */
    public static final String REQ_HEADER_SN = "X-Terminal-SN";
    /**
     * The constant XML_FILE_PREFIX.
     */
    public static final String XML_FILE_PREFIX = "<?xml";
    
    public static final int DEFAULT_PAGE_SIZE = 10;
    
    public static final String THIRD_PARTY_API_SDK_LANGUAGE = "Java";
    public static final String THIRD_PARTY_API_SDK_VERSION = "8.1.0";
    public static final String REQ_HEADER_SDK_LANG = "SDK-Language";
    public static final String REQ_HEADER_SDK_VERSION = "SDK-Version";

}
