/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.reader.influxdb2reader;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.element.StringColumn;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordSender;
import com.wgzhao.addax.common.plugin.TaskPluginCollector;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.plugin.reader.influxdb2reader.InfluxDBReaderErrorCode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBReaderTask {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBReaderTask.class);
    private static final int CONNECT_TIMEOUT_SECONDS_DEFAULT = 15;
    private static final int SOCKET_TIMEOUT_SECONDS_DEFAULT = 20;
    private String querySql;
    private final String database;
    private final String endpoint;
    private final String username;
    private final String password;
    private final int connTimeout;
    private final int socketTimeout;

    public InfluxDBReaderTask(Configuration configuration) {
        List connList = configuration.getList("connection");
        Configuration conn = Configuration.from((String)connList.get(0).toString());
        this.querySql = configuration.getString("querySql", null);
        this.database = conn.getString("database");
        this.endpoint = conn.getString("endpoint");
        this.username = configuration.getString("username");
        this.password = configuration.getString("password", null);
        this.connTimeout = configuration.getInt("connTimeout", 15) * 1000;
        this.socketTimeout = configuration.getInt("socketTimeout", 20) * 1000;
    }

    public void post() {
    }

    public void destroy() {
    }

    public void startRead(RecordSender recordSender, TaskPluginCollector taskPluginCollector) {
        String result;
        LOG.info("connect influxdb: {} with username: {}", (Object)this.endpoint, (Object)this.username);
        String tail = "/query";
        String enc = "utf-8";
        try {
            String url = this.endpoint + tail + "?db=" + URLEncoder.encode(this.database, enc);
            if (!"".equals(this.username)) {
                url = url + "&u=" + URLEncoder.encode(this.username, enc);
            }
            if (!"".equals(this.password)) {
                url = url + "&p=" + URLEncoder.encode(this.password, enc);
            }
            if (this.querySql.contains("#lastMinute#")) {
                this.querySql = this.querySql.replace("#lastMinute#", this.getLastMinute());
            }
            url = url + "&q=" + URLEncoder.encode(this.querySql, enc);
            result = this.get(url);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.ILLEGAL_VALUE, (String)"Failed to get data point\uff01", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.ILLEGAL_VALUE, (String)"Get nothing!", null);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            JSONArray results = (JSONArray)jsonObject.get((Object)"results");
            JSONObject resultsMap = (JSONObject)results.get(0);
            if (resultsMap.containsKey((Object)"series")) {
                JSONArray series = (JSONArray)resultsMap.get((Object)"series");
                JSONObject seriesMap = (JSONObject)series.get(0);
                if (seriesMap.containsKey((Object)"values")) {
                    JSONArray values = (JSONArray)seriesMap.get((Object)"values");
                    for (Object row : values) {
                        JSONArray rowArray = (JSONArray)row;
                        Record record = recordSender.createRecord();
                        for (Object s : rowArray) {
                            if (null != s) {
                                record.addColumn((Column)new StringColumn(s.toString()));
                                continue;
                            }
                            record.addColumn((Column)new StringColumn());
                        }
                        recordSender.sendToWriter(record);
                    }
                }
            } else if (resultsMap.containsKey((Object)"error")) {
                throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.ILLEGAL_VALUE, (String)"Error occurred in data sets\uff01", null);
            }
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.ILLEGAL_VALUE, (String)"Failed to send data", (Throwable)e);
        }
    }

    public String get(String url) throws Exception {
        Content content = Request.Get((String)url).connectTimeout(this.connTimeout).socketTimeout(this.socketTimeout).execute().returnContent();
        if (content == null) {
            return null;
        }
        return content.asString(StandardCharsets.UTF_8);
    }

    private String post(String url, Map<String, Object> params) throws Exception {
        return this.post(url, JSON.toJSONString(params), this.connTimeout, this.socketTimeout);
    }

    private String post(String url, String params) throws Exception {
        return this.post(url, params, this.connTimeout, this.socketTimeout);
    }

    private String post(String url, Map<String, Object> params, int connectTimeoutInMill, int socketTimeoutInMill) throws Exception {
        return this.post(url, JSON.toJSONString(params), connectTimeoutInMill, socketTimeoutInMill);
    }

    private String post(String url, String params, int connectTimeoutInMill, int socketTimeoutInMill) throws Exception {
        Content content = Request.Post((String)url).connectTimeout(connectTimeoutInMill).socketTimeout(socketTimeoutInMill).addHeader("Content-Type", "application/json").bodyString(params, ContentType.APPLICATION_JSON).execute().returnContent();
        if (content == null) {
            return null;
        }
        return content.asString(StandardCharsets.UTF_8);
    }

    private String getLastMinute() {
        long lastMinuteMilli = LocalDateTime.now().plusMinutes(-1L).toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return String.valueOf(lastMinuteMilli);
    }
}

