/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.reader.excelreader;

import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordSender;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.spi.Reader;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.plugin.reader.excelreader.ExcelHelper;
import com.wgzhao.addax.plugin.reader.excelreader.ExcelReaderErrorCode;
import com.wgzhao.addax.storage.util.FileHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader
extends Reader {

    public static class Task
    extends Reader.Task {
        private static final Logger LOG = LoggerFactory.getLogger(Task.class);
        private List<String> sourceFiles;
        private boolean header = false;
        private int skipRows = 0;

        public void init() {
            Configuration readerSliceConfig = this.getPluginJobConf();
            this.sourceFiles = readerSliceConfig.getList("sourceFiles", String.class);
            this.header = readerSliceConfig.getBool("header", false);
            if (this.header) {
                LOG.info("The first row is skipped as a table header");
            }
            this.skipRows = readerSliceConfig.getInt("skipRows", 0);
            if (this.skipRows > 0) {
                LOG.info("The first {} rows is skipped", (Object)this.skipRows);
            }
        }

        public void destroy() {
        }

        public void startRead(RecordSender recordSender) {
            for (String file : this.sourceFiles) {
                LOG.info("begin read file {}", (Object)file);
                ExcelHelper excelHelper = new ExcelHelper(this.header, this.skipRows);
                excelHelper.open(file);
                Record record = excelHelper.readLine(recordSender.createRecord());
                while (record != null) {
                    recordSender.sendToWriter(record);
                    record = excelHelper.readLine(recordSender.createRecord());
                }
                excelHelper.close();
            }
        }
    }

    public static class Job
    extends Reader.Job {
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);
        private Configuration originConfig = null;
        private List<String> path = null;
        private List<String> sourceFiles;
        private final Map<String, Pattern> pattern = new HashMap<String, Pattern>();
        private final Map<String, Boolean> isRegexPath = new HashMap<String, Boolean>();

        public void init() {
            this.originConfig = this.getPluginJobConf();
            String pathInString = this.originConfig.getNecessaryValue("path", (ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE);
            if (StringUtils.isBlank((CharSequence)pathInString)) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE, (String)"the path is required");
            }
            if (!pathInString.startsWith("[") && !pathInString.endsWith("]")) {
                this.path = new ArrayList<String>();
                this.path.add(pathInString);
            } else {
                this.path = this.originConfig.getList("path", String.class);
                if (null == this.path || this.path.isEmpty()) {
                    throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE, (String)"the path is required");
                }
            }
            this.sourceFiles = FileHelper.buildSourceTargets(this.path);
            LOG.info("The number of files to read is: [{}]", (Object)this.sourceFiles.size());
        }

        public void destroy() {
        }

        public List<Configuration> split(int adviceNumber) {
            LOG.debug("Begin to split...");
            ArrayList<Configuration> readerSplitConfigs = new ArrayList<Configuration>();
            int splitNumber = this.sourceFiles.size();
            if (0 == splitNumber) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.EMPTY_DIR_EXCEPTION, (String)("Nothing found in the directory " + this.originConfig.getString("path") + ". Please check it"));
            }
            List splitSourceFiles = FileHelper.splitSourceFiles(this.sourceFiles, (int)splitNumber);
            for (List files : splitSourceFiles) {
                Configuration splitConfig = this.originConfig.clone();
                splitConfig.set("sourceFiles", (Object)files);
                readerSplitConfigs.add(splitConfig);
            }
            LOG.debug("Split finished...");
            return readerSplitConfigs;
        }
    }
}

