/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.reader.excelreader;

import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordSender;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.spi.Reader;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.plugin.reader.excelreader.ExcelHelper;
import com.wgzhao.addax.plugin.reader.excelreader.ExcelReaderErrorCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader
extends Reader {

    public static class Task
    extends Reader.Task {
        private static final Logger LOG = LoggerFactory.getLogger(Task.class);
        private List<String> sourceFiles;
        private boolean header = false;
        private int skipRows = 0;

        public void init() {
            Configuration readerSliceConfig = this.getPluginJobConf();
            this.sourceFiles = readerSliceConfig.getList("sourceFiles", String.class);
            this.header = readerSliceConfig.getBool("header", false);
            if (this.header) {
                LOG.info("The first row is skipped as a table header");
            }
            this.skipRows = readerSliceConfig.getInt("skipRows", 0);
            if (this.skipRows > 0) {
                LOG.info("The first {} rows is skipped", (Object)this.skipRows);
            }
        }

        public void destroy() {
        }

        public void startRead(RecordSender recordSender) {
            for (String file : this.sourceFiles) {
                LOG.info("begin read file {}", (Object)file);
                ExcelHelper excelHelper = new ExcelHelper(this.header, this.skipRows);
                excelHelper.open(file);
                Record record = excelHelper.readLine(recordSender.createRecord());
                while (record != null) {
                    recordSender.sendToWriter(record);
                    record = excelHelper.readLine(recordSender.createRecord());
                }
                excelHelper.close();
            }
        }
    }

    public static class Job
    extends Reader.Job {
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);
        private Configuration originConfig = null;
        private List<String> path = null;
        private List<String> sourceFiles;
        private final Map<String, Pattern> pattern = new HashMap<String, Pattern>();
        private final Map<String, Boolean> isRegexPath = new HashMap<String, Boolean>();

        public void init() {
            this.originConfig = this.getPluginJobConf();
            String pathInString = this.originConfig.getNecessaryValue("path", (ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE);
            if (StringUtils.isBlank((CharSequence)pathInString)) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE, (String)"the path is required");
            }
            if (!pathInString.startsWith("[") && !pathInString.endsWith("]")) {
                this.path = new ArrayList<String>();
                this.path.add(pathInString);
            } else {
                this.path = this.originConfig.getList("path", String.class);
                if (null == this.path || this.path.isEmpty()) {
                    throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.REQUIRED_VALUE, (String)"the path is required");
                }
            }
            for (String eachPath : this.path) {
                String regexString = eachPath.replace("*", ".*").replace("?", ".?");
                Pattern pattern = Pattern.compile(regexString);
                this.pattern.put(eachPath, pattern);
            }
            this.sourceFiles = this.buildSourceTargets();
            LOG.info("The number of files to read is: [{}]", (Object)this.sourceFiles.size());
        }

        public void destroy() {
        }

        public List<Configuration> split(int adviceNumber) {
            LOG.debug("Begin to split...");
            ArrayList<Configuration> readerSplitConfigs = new ArrayList<Configuration>();
            int splitNumber = this.sourceFiles.size();
            if (0 == splitNumber) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.EMPTY_DIR_EXCEPTION, (String)("Nothing found in the directory " + this.originConfig.getString("path") + ". Please check it"));
            }
            List<List<String>> splitedSourceFiles = this.splitSourceFiles(this.sourceFiles, splitNumber);
            for (List<String> files : splitedSourceFiles) {
                Configuration splitedConfig = this.originConfig.clone();
                splitedConfig.set("sourceFiles", files);
                readerSplitConfigs.add(splitedConfig);
            }
            LOG.debug("Split finished...");
            return readerSplitConfigs;
        }

        private List<String> buildSourceTargets() {
            HashSet<String> toBeReadFiles = new HashSet<String>();
            for (String eachPath : this.path) {
                String parentDirectory;
                int endMark;
                for (endMark = 0; endMark < eachPath.length(); ++endMark) {
                    if ('*' != eachPath.charAt(endMark) && '?' != eachPath.charAt(endMark)) continue;
                    this.isRegexPath.put(eachPath, true);
                    break;
                }
                if (BooleanUtils.isTrue((Boolean)this.isRegexPath.get(eachPath))) {
                    int lastDirSeparator = eachPath.substring(0, endMark).lastIndexOf(IOUtils.DIR_SEPARATOR);
                    parentDirectory = eachPath.substring(0, lastDirSeparator + 1);
                } else {
                    this.isRegexPath.put(eachPath, false);
                    parentDirectory = eachPath;
                }
                this.buildSourceTargetsEachPath(eachPath, parentDirectory, toBeReadFiles);
            }
            return Arrays.asList(toBeReadFiles.toArray(new String[0]));
        }

        private void buildSourceTargetsEachPath(String regexPath, String parentDirectory, Set<String> toBeReadFiles) {
            try {
                File dir = new File(parentDirectory);
                boolean isExists = dir.exists();
                if (!isExists) {
                    throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.FILE_NOT_EXISTS, (String)(parentDirectory + ": No such file or directory"));
                }
            }
            catch (SecurityException se) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.SECURITY_NOT_ENOUGH, (String)("Permission denied for directory: " + parentDirectory));
            }
            this.directoryRover(regexPath, parentDirectory, toBeReadFiles);
        }

        private void directoryRover(String regexPath, String parentDirectory, Set<String> toBeReadFiles) {
            block9: {
                File directory = new File(parentDirectory);
                if (!directory.isDirectory()) {
                    if (this.isTargetFile(regexPath, directory.getAbsolutePath())) {
                        if (parentDirectory.endsWith(".xlsx") || parentDirectory.endsWith(".xls")) {
                            toBeReadFiles.add(parentDirectory);
                        } else {
                            LOG.warn("File {} is not valid Excel file, ignore it", (Object)parentDirectory);
                        }
                        LOG.info("add file [{}] as a candidate to be read.", (Object)parentDirectory);
                    }
                } else {
                    try {
                        File[] files = directory.listFiles();
                        if (null != files) {
                            for (File subFileNames : files) {
                                this.directoryRover(regexPath, subFileNames.getAbsolutePath(), toBeReadFiles);
                            }
                            break block9;
                        }
                        String message = String.format("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u76ee\u5f55 : [%s]", directory);
                        LOG.error(message);
                        throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.SECURITY_NOT_ENOUGH, (String)message);
                    }
                    catch (SecurityException e) {
                        String message = String.format("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u76ee\u5f55 : [%s]", directory);
                        LOG.error(message);
                        throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.SECURITY_NOT_ENOUGH, (String)message, (Throwable)e);
                    }
                }
            }
        }

        private <T> List<List<T>> splitSourceFiles(List<T> sourceList, int adviceNumber) {
            ArrayList<List<T>> splitedList = new ArrayList<List<T>>();
            int averageLength = sourceList.size() / adviceNumber;
            averageLength = averageLength == 0 ? 1 : averageLength;
            int begin = 0;
            while (begin < sourceList.size()) {
                int end = begin + averageLength;
                if (end > sourceList.size()) {
                    end = sourceList.size();
                }
                splitedList.add(sourceList.subList(begin, end));
                begin = end;
            }
            return splitedList;
        }

        private boolean isTargetFile(String regexPath, String absoluteFilePath) {
            if (this.isRegexPath.get(regexPath).booleanValue()) {
                return this.pattern.get(regexPath).matcher(absoluteFilePath).matches();
            }
            return true;
        }
    }
}

