/*
 * Decompiled with CFR 0.152.
 */
package com.weigan.loopview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.weigan.loopview.InertiaTimerTask;
import com.weigan.loopview.LoopViewGestureListener;
import com.weigan.loopview.MessageHandler;
import com.weigan.loopview.OnItemSelectedListener;
import com.weigan.loopview.OnItemSelectedRunnable;
import com.weigan.loopview.R;
import com.weigan.loopview.SmoothScrollTimerTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LoopView
extends View {
    private float scaleX = 1.05f;
    private static final int DEFAULT_TEXT_SIZE = (int)(Resources.getSystem().getDisplayMetrics().density * 15.0f);
    private static final float DEFAULT_LINE_SPACE = 1.0f;
    private static final int DEFAULT_VISIBIE_ITEMS = 9;
    private Context context;
    Handler handler;
    private GestureDetector flingGestureDetector;
    OnItemSelectedListener onItemSelectedListener;
    ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    private Paint paintOuterText;
    private Paint paintCenterText;
    private Paint paintIndicator;
    List<IndexString> items;
    int textSize;
    int itemTextHeight;
    int textHeight;
    int outerTextColor;
    int centerTextColor;
    int dividerColor;
    float lineSpacingMultiplier;
    boolean isLoop;
    int firstLineY;
    int secondLineY;
    int totalScrollY;
    int initPosition;
    private int selectedItem;
    int preCurrentIndex;
    int change;
    int itemsVisibleCount;
    HashMap<Integer, IndexString> drawingStrings;
    int measuredHeight;
    int measuredWidth;
    int halfCircumference;
    int radius;
    private int mOffset = 0;
    private float previousY;
    long startTime = 0L;
    private Rect tempRect = new Rect();
    private int paddingLeft;
    private int paddingRight;
    private Typeface typeface = Typeface.MONOSPACE;

    public void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        if (lineSpacingMultiplier > 1.0f) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
        }
    }

    public void setCenterTextColor(int centerTextColor) {
        this.centerTextColor = centerTextColor;
        this.paintCenterText.setColor(centerTextColor);
    }

    public void setOuterTextColor(int outerTextColor) {
        this.outerTextColor = outerTextColor;
        this.paintOuterText.setColor(outerTextColor);
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.paintIndicator.setColor(dividerColor);
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
    }

    public LoopView(Context context) {
        super(context);
        this.initLoopView(context, null);
    }

    public LoopView(Context context, AttributeSet attributeset) {
        super(context, attributeset);
        this.initLoopView(context, attributeset);
    }

    public LoopView(Context context, AttributeSet attributeset, int defStyleAttr) {
        super(context, attributeset, defStyleAttr);
        this.initLoopView(context, attributeset);
    }

    private void initLoopView(Context context, AttributeSet attributeset) {
        this.context = context;
        this.handler = new MessageHandler(this);
        this.flingGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new LoopViewGestureListener(this));
        this.flingGestureDetector.setIsLongpressEnabled(false);
        TypedArray typedArray = context.obtainStyledAttributes(attributeset, R.styleable.LoopView);
        if (typedArray != null) {
            this.textSize = typedArray.getInteger(R.styleable.LoopView_awv_textsize, DEFAULT_TEXT_SIZE);
            this.textSize = (int)(Resources.getSystem().getDisplayMetrics().density * (float)this.textSize);
            this.lineSpacingMultiplier = typedArray.getFloat(R.styleable.LoopView_awv_lineSpace, 1.0f);
            this.centerTextColor = typedArray.getInteger(R.styleable.LoopView_awv_centerTextColor, -13553359);
            this.outerTextColor = typedArray.getInteger(R.styleable.LoopView_awv_outerTextColor, -5263441);
            this.dividerColor = typedArray.getInteger(R.styleable.LoopView_awv_dividerTextColor, -3815995);
            this.itemsVisibleCount = typedArray.getInteger(R.styleable.LoopView_awv_itemsVisibleCount, 9);
            if (this.itemsVisibleCount % 2 == 0) {
                this.itemsVisibleCount = 9;
            }
            this.isLoop = typedArray.getBoolean(R.styleable.LoopView_awv_isLoop, true);
            typedArray.recycle();
        }
        this.drawingStrings = new HashMap();
        this.totalScrollY = 0;
        this.initPosition = -1;
    }

    public void setItemsVisibleCount(int visibleNumber) {
        if (visibleNumber % 2 == 0) {
            return;
        }
        if (visibleNumber != this.itemsVisibleCount) {
            this.itemsVisibleCount = visibleNumber;
            this.drawingStrings = new HashMap();
        }
    }

    private void initPaintsIfPosssible() {
        if (this.paintOuterText == null) {
            this.paintOuterText = new Paint();
            this.paintOuterText.setColor(this.outerTextColor);
            this.paintOuterText.setAntiAlias(true);
            this.paintOuterText.setTypeface(this.typeface);
            this.paintOuterText.setTextSize((float)this.textSize);
        }
        if (this.paintCenterText == null) {
            this.paintCenterText = new Paint();
            this.paintCenterText.setColor(this.centerTextColor);
            this.paintCenterText.setAntiAlias(true);
            this.paintCenterText.setTextScaleX(this.scaleX);
            this.paintCenterText.setTypeface(this.typeface);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
        if (this.paintIndicator == null) {
            this.paintIndicator = new Paint();
            this.paintIndicator.setColor(this.dividerColor);
            this.paintIndicator.setAntiAlias(true);
        }
    }

    private void remeasure() {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        this.measuredWidth = this.getMeasuredWidth();
        this.measuredHeight = this.getMeasuredHeight();
        if (this.measuredWidth == 0 || this.measuredHeight == 0) {
            return;
        }
        this.paddingLeft = this.getPaddingLeft();
        this.paddingRight = this.getPaddingRight();
        this.measuredWidth -= this.paddingRight;
        this.paintCenterText.getTextBounds("\u661f\u671f", 0, 2, this.tempRect);
        this.textHeight = this.tempRect.height();
        this.halfCircumference = (int)((double)this.measuredHeight * Math.PI / 2.0);
        this.itemTextHeight = (int)((float)this.halfCircumference / (this.lineSpacingMultiplier * (float)(this.itemsVisibleCount - 1)));
        this.radius = this.measuredHeight / 2;
        this.firstLineY = (int)(((float)this.measuredHeight - this.lineSpacingMultiplier * (float)this.itemTextHeight) / 2.0f);
        this.secondLineY = (int)(((float)this.measuredHeight + this.lineSpacingMultiplier * (float)this.itemTextHeight) / 2.0f);
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.items.size() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    void smoothScroll(ACTION action) {
        this.cancelFuture();
        if (action == ACTION.FLING || action == ACTION.DRAG) {
            float itemHeight = this.lineSpacingMultiplier * (float)this.itemTextHeight;
            this.mOffset = (int)(((float)this.totalScrollY % itemHeight + itemHeight) % itemHeight);
            this.mOffset = (float)this.mOffset > itemHeight / 2.0f ? (int)(itemHeight - (float)this.mOffset) : -this.mOffset;
        }
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new SmoothScrollTimerTask(this, this.mOffset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    protected final void scrollBy(float velocityY) {
        this.cancelFuture();
        int velocityFling = 10;
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new InertiaTimerTask(this, velocityY), 0L, velocityFling, TimeUnit.MILLISECONDS);
    }

    public void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public void setNotLoop() {
        this.isLoop = false;
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.context.getResources().getDisplayMetrics().density * size);
            this.paintOuterText.setTextSize((float)this.textSize);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public final void setInitPosition(int initPosition) {
        if (initPosition < 0) {
            this.initPosition = 0;
        } else if (this.items != null && this.items.size() > initPosition) {
            this.initPosition = initPosition;
        }
    }

    public final void setListener(OnItemSelectedListener OnItemSelectedListener2) {
        this.onItemSelectedListener = OnItemSelectedListener2;
    }

    public final void setItems(List<String> items) {
        this.items = this.convertData(items);
        this.remeasure();
        this.invalidate();
    }

    public List<IndexString> convertData(List<String> items) {
        ArrayList<IndexString> data = new ArrayList<IndexString>();
        for (int i = 0; i < items.size(); ++i) {
            data.add(new IndexString(i, items.get(i)));
        }
        return data;
    }

    public final int getSelectedItem() {
        return this.preCurrentIndex;
    }

    protected final void onItemSelected() {
        if (this.onItemSelectedListener != null) {
            this.postDelayed(new OnItemSelectedRunnable(this), 200L);
        }
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setCurrentPosition(int position) {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        int size = this.items.size();
        if (position >= 0 && position < size && position != this.selectedItem) {
            this.initPosition = position;
            this.totalScrollY = 0;
            this.mOffset = 0;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        this.change = (int)((float)this.totalScrollY / (this.lineSpacingMultiplier * (float)this.itemTextHeight));
        this.preCurrentIndex = this.initPosition + this.change % this.items.size();
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.items.size() - 1) {
                this.preCurrentIndex = this.items.size() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.items.size() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.items.size() - 1) {
                this.preCurrentIndex -= this.items.size();
            }
        }
        int j2 = (int)((float)this.totalScrollY % (this.lineSpacingMultiplier * (float)this.itemTextHeight));
        for (int k1 = 0; k1 < this.itemsVisibleCount; ++k1) {
            int l1;
            if (this.isLoop) {
                for (l1 = this.preCurrentIndex - (this.itemsVisibleCount / 2 - k1); l1 < 0; l1 += this.items.size()) {
                }
                while (l1 > this.items.size() - 1) {
                    l1 -= this.items.size();
                }
                this.drawingStrings.put(k1, this.items.get(l1));
                continue;
            }
            if (l1 < 0) {
                this.drawingStrings.put(k1, new IndexString());
                continue;
            }
            if (l1 > this.items.size() - 1) {
                this.drawingStrings.put(k1, new IndexString());
                continue;
            }
            this.drawingStrings.put(k1, this.items.get(l1));
        }
        canvas.drawLine((float)this.paddingLeft, (float)this.firstLineY, (float)this.measuredWidth, (float)this.firstLineY, this.paintIndicator);
        canvas.drawLine((float)this.paddingLeft, (float)this.secondLineY, (float)this.measuredWidth, (float)this.secondLineY, this.paintIndicator);
        for (int i = 0; i < this.itemsVisibleCount; ++i) {
            canvas.save();
            float itemHeight = (float)this.itemTextHeight * this.lineSpacingMultiplier;
            double radian = (double)(itemHeight * (float)i - (float)j2) * Math.PI / (double)this.halfCircumference;
            if (radian >= Math.PI || radian <= 0.0) {
                canvas.restore();
                continue;
            }
            int translateY = (int)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.itemTextHeight / 2.0);
            canvas.translate(0.0f, (float)translateY);
            canvas.scale(1.0f, (float)Math.sin(radian));
            if (translateY <= this.firstLineY && this.itemTextHeight + translateY >= this.firstLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, this.firstLineY - translateY);
                this.drawOuterText(canvas, i);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.firstLineY - translateY, this.measuredWidth, (int)itemHeight);
                this.drawCenterText(canvas, i);
                canvas.restore();
            } else if (translateY <= this.secondLineY && this.itemTextHeight + translateY >= this.secondLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, this.secondLineY - translateY);
                this.drawCenterText(canvas, i);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.secondLineY - translateY, this.measuredWidth, (int)itemHeight);
                this.drawOuterText(canvas, i);
                canvas.restore();
            } else if (translateY >= this.firstLineY && this.itemTextHeight + translateY <= this.secondLineY) {
                canvas.clipRect(0, 0, this.measuredWidth, (int)itemHeight);
                this.drawCenterText(canvas, i);
                this.selectedItem = this.items.indexOf(this.drawingStrings.get(i));
            } else {
                canvas.clipRect(0, 0, this.measuredWidth, (int)itemHeight);
                this.drawOuterText(canvas, i);
            }
            canvas.restore();
        }
    }

    private void drawOuterText(Canvas canvas, int position) {
        canvas.drawText(this.drawingStrings.get(position).string, (float)this.getTextX(this.drawingStrings.get(position).string, this.paintOuterText, this.tempRect), (float)this.getDrawingY(), this.paintOuterText);
    }

    private void drawCenterText(Canvas canvas, int position) {
        canvas.drawText(this.drawingStrings.get(position).string, (float)this.getTextX(this.drawingStrings.get(position).string, this.paintOuterText, this.tempRect), (float)this.getDrawingY(), this.paintCenterText);
    }

    private int getDrawingY() {
        if (this.itemTextHeight > this.textHeight) {
            return this.itemTextHeight - (this.itemTextHeight - this.textHeight) / 2;
        }
        return this.itemTextHeight;
    }

    private int getTextX(String a, Paint paint, Rect rect) {
        paint.getTextBounds(a, 0, a.length(), rect);
        int textWidth = rect.width();
        textWidth = (int)((float)textWidth * this.scaleX);
        return (this.measuredWidth - this.paddingLeft - textWidth) / 2 + this.paddingLeft;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initPaintsIfPosssible();
        this.remeasure();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean eventConsumed = this.flingGestureDetector.onTouchEvent(event);
        float itemHeight = this.lineSpacingMultiplier * (float)this.itemTextHeight;
        switch (event.getAction()) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.cancelFuture();
                this.previousY = event.getRawY();
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float dy = this.previousY - event.getRawY();
                this.previousY = event.getRawY();
                this.totalScrollY = (int)((float)this.totalScrollY + dy);
                if (this.isLoop) break;
                float top = (float)(-this.initPosition) * itemHeight;
                float bottom = (float)(this.items.size() - 1 - this.initPosition) * itemHeight;
                if ((float)this.totalScrollY < top) {
                    this.totalScrollY = (int)top;
                    break;
                }
                if (!((float)this.totalScrollY > bottom)) break;
                this.totalScrollY = (int)bottom;
                break;
            }
            default: {
                if (!eventConsumed) {
                    float y = event.getY();
                    double l = Math.acos(((float)this.radius - y) / (float)this.radius) * (double)this.radius;
                    int circlePosition = (int)((l + (double)(itemHeight / 2.0f)) / (double)itemHeight);
                    float extraOffset = ((float)this.totalScrollY % itemHeight + itemHeight) % itemHeight;
                    this.mOffset = (int)((float)(circlePosition - this.itemsVisibleCount / 2) * itemHeight - extraOffset);
                    if (System.currentTimeMillis() - this.startTime > 120L) {
                        this.smoothScroll(ACTION.DRAG);
                    } else {
                        this.smoothScroll(ACTION.CLICK);
                    }
                }
                if (this.getParent() == null) break;
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        this.invalidate();
        return true;
    }

    class IndexString {
        private String string;
        private int index;

        public IndexString() {
            this.string = "";
        }

        public IndexString(int index, String str) {
            this.index = index;
            this.string = str;
        }
    }

    public static enum ACTION {
        CLICK,
        FLING,
        DRAG;

    }
}

