/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4.http;

import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.concurrent.ThreadPoolExecutor;

@ChannelHandler.Sharable
public class NettyHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public static final String BAD_REQUEST = "/bad-request";
    public static final String ROOT_PATH = "/";
    public static final String STATUS_PATH = "/rpcstatus";
    private Channel serverChannel;
    private ThreadPoolExecutor threadPoolExecutor;
    private MessageHandler messageHandler;
    protected String swictherName = "feature.configserver.heartbeat";

    public NettyHttpRequestHandler(Channel serverChannel) {
        this.serverChannel = serverChannel;
    }

    public NettyHttpRequestHandler(Channel serverChannel, MessageHandler messageHandler) {
        this.serverChannel = serverChannel;
        this.messageHandler = messageHandler;
    }

    public NettyHttpRequestHandler(Channel serverChannel, MessageHandler messageHandler, ThreadPoolExecutor threadPoolExecutor) {
        this.serverChannel = serverChannel;
        this.messageHandler = messageHandler;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, final FullHttpRequest httpRequest) throws Exception {
        if (BAD_REQUEST.equals(httpRequest.getUri())) {
            this.sendResponse(ctx, this.buildDefaultResponse("bad request!", HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (ROOT_PATH.equals(httpRequest.getUri()) || STATUS_PATH.equals(httpRequest.getUri())) {
            if (this.isSwitchOpen()) {
                this.sendResponse(ctx, this.buildDefaultResponse("ok!", HttpResponseStatus.OK));
            } else {
                this.sendResponse(ctx, this.buildErrorResponse("service not available!"));
            }
            return;
        }
        httpRequest.content().retain();
        if (this.threadPoolExecutor == null) {
            this.processHttpRequest(ctx, httpRequest);
        } else {
            try {
                this.threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyHttpRequestHandler.this.processHttpRequest(ctx, httpRequest);
                    }
                });
            }
            catch (Exception e) {
                LoggerUtil.error((String)"request is rejected by threadpool!", (Throwable)e);
                httpRequest.content().release();
                this.sendResponse(ctx, this.buildErrorResponse("request is rejected by threadpool!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttpRequest(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        FullHttpResponse httpResponse = null;
        try {
            httpResponse = (FullHttpResponse)this.messageHandler.handle(this.serverChannel, (Object)httpRequest);
        }
        catch (Exception e) {
            LoggerUtil.error((String)"NettyHttpHandler process http request fail.", (Throwable)e);
            httpResponse = this.buildErrorResponse(e.getMessage());
        }
        finally {
            httpRequest.content().release();
        }
        this.sendResponse(ctx, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ChannelHandlerContext ctx, FullHttpResponse httpResponse) {
        boolean close = false;
        try {
            ctx.write((Object)httpResponse);
            ctx.flush();
        }
        catch (Exception e) {
            LoggerUtil.error((String)"NettyHttpHandler write response fail.", (Throwable)e);
            close = true;
        }
        finally {
            if (close || httpResponse == null || !"keep-alive".equals(httpResponse.headers().get("Connection"))) {
                ctx.close();
            }
        }
    }

    protected FullHttpResponse buildErrorResponse(String errMsg) {
        return this.buildDefaultResponse(errMsg, HttpResponseStatus.SERVICE_UNAVAILABLE);
    }

    protected FullHttpResponse buildDefaultResponse(String msg, HttpResponseStatus status) {
        DefaultFullHttpResponse errorResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])msg.getBytes()));
        return errorResponse;
    }

    protected boolean isSwitchOpen() {
        return MotanSwitcherUtil.isOpen((String)this.swictherName);
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

