/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.yar;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.yar.YarRpcProtocol;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.EndpointFactory;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.Server;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class YarExporter<T>
extends AbstractExporter<T> {
    protected Server server;
    private YarRpcProtocol yarProtocol;

    public YarExporter(URL url, Provider<T> provider, YarRpcProtocol yarProtocol) {
        super(provider, url);
        EndpointFactory endpointFactory = (EndpointFactory)ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), "netty4yar"));
        String heartbeatFactory = url.getParameter(URLParamType.heartbeatFactory.getName());
        if (heartbeatFactory == null) {
            url.addParameter(URLParamType.heartbeatFactory.getName(), "noHeartbeat");
        }
        this.validateInterface(provider.getInterface());
        this.server = endpointFactory.createServer(url, (MessageHandler)yarProtocol.initRequestRouter(url, provider));
    }

    public void destroy() {
        this.server.close();
    }

    public boolean isAvailable() {
        return this.server.isAvailable();
    }

    public void unexport() {
        this.yarProtocol.unexport(this.url, this.provider);
    }

    protected boolean doInit() {
        return this.server.open();
    }

    protected void validateInterface(Class<?> interfaceClazz) {
        HashMap<String, List<Integer>> tempMap = new HashMap<String, List<Integer>>();
        for (Method m : interfaceClazz.getDeclaredMethods()) {
            List<Integer> templist;
            if (!tempMap.containsKey(m.getName())) {
                templist = new ArrayList<Integer>();
                templist.add(m.getParameterTypes().length);
                tempMap.put(m.getName(), templist);
                continue;
            }
            templist = (List)tempMap.get(m.getName());
            if (templist.contains(m.getParameterTypes().length)) {
                throw new MotanFrameworkException("in yar protocol, methods with same name must have different params size !");
            }
            templist.add(m.getParameterTypes().length);
        }
    }
}

