/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.yar;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.protocol.yar.YarExporter;
import com.weibo.api.motan.protocol.yar.YarMessageRouter;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.concurrent.ConcurrentHashMap;

@SpiMeta(name="yar")
public class YarRpcProtocol
extends AbstractProtocol {
    private ConcurrentHashMap<String, ProviderMessageRouter> ipPort2RequestRouter = new ConcurrentHashMap();

    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        return new YarExporter<T>(url, provider, this);
    }

    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        throw new MotanFrameworkException("not yet implemented!");
    }

    public ProviderMessageRouter initRequestRouter(URL url, Provider<?> provider) {
        String ipPort = url.getServerPortStr();
        ProviderMessageRouter requestRouter = this.ipPort2RequestRouter.get(ipPort);
        if (requestRouter == null) {
            this.ipPort2RequestRouter.putIfAbsent(ipPort, (ProviderMessageRouter)new YarMessageRouter());
            requestRouter = this.ipPort2RequestRouter.get(ipPort);
        }
        requestRouter.addProvider(provider);
        return requestRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(URL url, Provider<?> provider) {
        String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)url);
        String ipPort = url.getServerPortStr();
        Exporter exporter = (Exporter)this.exporterMap.remove(protocolKey);
        if (exporter != null) {
            exporter.destroy();
        }
        ConcurrentHashMap<String, ProviderMessageRouter> concurrentHashMap = this.ipPort2RequestRouter;
        synchronized (concurrentHashMap) {
            ProviderMessageRouter requestRouter = this.ipPort2RequestRouter.get(ipPort);
            if (requestRouter != null) {
                requestRouter.removeProvider(provider);
            }
        }
        LoggerUtil.info((String)"yarRpcExporter unexport Success: url={}", (Object[])new Object[]{url});
    }
}

