/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.config.DefaultGlobalConfig;
import com.weibo.api.motan.config.GlobalConfig;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class MotanGlobalConfigUtil {
    public static final String MOTAN_CONFIG_FILE = "motan.properties";
    private static final Map<String, String> DEFAULT_CONFIGS = new HashMap<String, String>();
    private static volatile GlobalConfig innerGlobalConfig;

    public static Map<String, String> getDefaultConfigCopy() {
        return new HashMap<String, String>(DEFAULT_CONFIGS);
    }

    public static String getConfig(String key) {
        return innerGlobalConfig.getConfig(key);
    }

    public static String getConfig(String key, String defaultValue) {
        return innerGlobalConfig.getConfig(key, defaultValue);
    }

    public static void putConfig(String key, String value) {
        innerGlobalConfig.putConfig(key, value);
    }

    public static String remove(String key) {
        return innerGlobalConfig.remove(key);
    }

    public static void putConfigs(Map<String, String> configs, boolean override) {
        innerGlobalConfig.putConfigs(configs, override);
    }

    public static ConcurrentHashMap<String, String> getConfigs() {
        return innerGlobalConfig.getConfigs();
    }

    public static GlobalConfig setInnerGlobalConfig(GlobalConfig newConfig) {
        if (newConfig != null) {
            GlobalConfig oldConfig = innerGlobalConfig;
            innerGlobalConfig = newConfig;
            return oldConfig;
        }
        return null;
    }

    private static void init() {
        URL url = Thread.currentThread().getContextClassLoader().getResource(MOTAN_CONFIG_FILE);
        if (url != null) {
            try (InputStream is = url.openStream();){
                LoggerUtil.info("load default motan properties from " + url.getPath());
                Properties properties = new Properties();
                properties.load(is);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
                    DEFAULT_CONFIGS.put(key.trim(), value.trim());
                }
            }
            catch (IOException e) {
                LoggerUtil.warn("load default motan properties fail. err:" + e.getMessage(), e);
            }
        }
        LoggerUtil.info("default motan properties:" + DEFAULT_CONFIGS);
        innerGlobalConfig = new DefaultGlobalConfig();
    }

    static {
        MotanGlobalConfigUtil.init();
    }
}

