/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.registry.RegistryFactory;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MeshProxyUtil {
    private static final String MODE_KEY = "mode";
    private static final String PORT_KEY = "port";
    private static final String IP_KEY = "ip";
    private static final String PROTOCOL_KEY = "protocol";
    private static final String MODE_SERVER = "server";
    private static final String MODE_CLIENT = "client";
    private static final String MODE_ALL = "all";
    private static final String DEFAULT_PORT = "0";
    private static final String MESH_REGISTRY_NAME = "weibomesh";
    private static final Set<String> NOT_PROCESS_REGISTRY_PROTOCOLS = new HashSet<String>(Arrays.asList("local", "direct", "weibomesh"));
    private static Boolean initChecked;
    private static Map<String, String> proxyConfig;

    public static List<URL> processMeshProxy(List<URL> originRegistryUrls, URL serviceUrl, boolean isServerEnd) {
        if (MeshProxyUtil.needProcess(serviceUrl, isServerEnd)) {
            try {
                ArrayList<URL> newRegistryUrls = new ArrayList<URL>(originRegistryUrls.size());
                for (URL url : originRegistryUrls) {
                    if (NOT_PROCESS_REGISTRY_PROTOCOLS.contains(url.getProtocol())) {
                        newRegistryUrls.add(url);
                        LoggerUtil.info("mesh proxy ignore url:" + serviceUrl.toSimpleString() + ", registry: " + url.toSimpleString());
                        continue;
                    }
                    URL meshRegistryUrl = MeshProxyUtil.buildMeshRegistryUrl(url);
                    newRegistryUrls.add(meshRegistryUrl);
                    LoggerUtil.info("build mesh proxy registry for url:" + serviceUrl.toSimpleString() + ", origin registry:" + url.toSimpleString() + ", mesh registry url:" + meshRegistryUrl.toFullStr());
                }
                return newRegistryUrls;
            }
            catch (Exception e) {
                LoggerUtil.error("proxy motan fail", e);
            }
        }
        return originRegistryUrls;
    }

    public static boolean needProcess(URL serviceUrl, boolean isServerEnd) {
        if (!initChecked.booleanValue()) {
            return false;
        }
        String mode = proxyConfig.get(MODE_KEY);
        if (StringUtils.isBlank((CharSequence)mode)) {
            return false;
        }
        if (!(MODE_ALL.equals(mode) || MODE_SERVER.equals(mode) || MODE_CLIENT.equals(mode))) {
            return false;
        }
        if (MODE_CLIENT.equals(mode) && isServerEnd) {
            return false;
        }
        if (MODE_SERVER.equals(mode) && !isServerEnd) {
            return false;
        }
        if (!"motan2".equals(serviceUrl.getProtocol()) && !"motan".equals(serviceUrl.getProtocol())) {
            return false;
        }
        String protocol = proxyConfig.get(PROTOCOL_KEY);
        return !StringUtils.isNotBlank((CharSequence)protocol) || protocol.equals(serviceUrl.getProtocol());
    }

    private static Map<String, String> parseProxyConfig(String meshProxyString) {
        String[] items;
        HashMap<String, String> proxyConfig = new HashMap<String, String>();
        for (String item : items = meshProxyString.split(",")) {
            String[] values = item.split(":");
            if (!StringUtils.isNotBlank((CharSequence)values[0])) continue;
            String k = values[0].trim();
            String v = "";
            if (values.length > 1 && StringUtils.isNotBlank((CharSequence)values[1])) {
                v = StringTools.urlDecode(values[1].trim());
            }
            proxyConfig.put(k, v);
            LoggerUtil.info("add mesh proxy param: " + k + ":" + v);
        }
        return proxyConfig;
    }

    private static URL buildMeshRegistryUrl(URL proxyRegistry) {
        URL meshRegistryUrl = new URL(MESH_REGISTRY_NAME, MeshProxyUtil.getValue(proxyConfig, IP_KEY, "localhost"), Integer.parseInt(MeshProxyUtil.getValue(proxyConfig, PORT_KEY, DEFAULT_PORT)), RegistryService.class.getName());
        HashMap<String, String> params = new HashMap<String, String>(proxyConfig);
        params.put(URLParamType.dynamic.getName(), "true");
        params.put(URLParamType.proxyRegistryUrlString.getName(), StringTools.urlEncode(proxyRegistry.toFullStr()));
        meshRegistryUrl.addParameters(params);
        return meshRegistryUrl;
    }

    private static String getValue(Map<String, String> configs, String key, String defaultValue) {
        String value = configs.get(key);
        return StringUtils.isNotBlank((CharSequence)value) ? value : defaultValue;
    }

    private static void initCheck() {
        String meshProxyString = System.getenv("MOTAN_MESH_PROXY");
        if (StringUtils.isNotBlank((CharSequence)meshProxyString)) {
            LoggerUtil.info("find MOTAN_MESH_PROXY env, value:" + meshProxyString);
            proxyConfig = MeshProxyUtil.parseProxyConfig(meshProxyString);
            RegistryFactory meshRegistryFactory = ExtensionLoader.getExtensionLoader(RegistryFactory.class).getExtension(MESH_REGISTRY_NAME, false);
            if (meshRegistryFactory != null) {
                initChecked = true;
                LoggerUtil.info("mesh proxy init check passed");
                return;
            }
            LoggerUtil.error("can not proxy motan, because MeshRegistry extension not found, maybe the dependency of 'motan-registry-weibomesh' not set in pom");
        }
        initChecked = false;
    }

    protected static void reset() {
        proxyConfig = null;
        MeshProxyUtil.initCheck();
    }

    protected static Map<String, String> getProxyConfig() {
        return proxyConfig;
    }

    protected static boolean setInitChecked(boolean value) {
        boolean oldValue = initChecked;
        initChecked = value;
        return oldValue;
    }

    static {
        MeshProxyUtil.initCheck();
    }
}

