/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.rpc.Callbackable;
import com.weibo.api.motan.util.AsyncUtil;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultCallbackHolder
implements Callbackable {
    private final List<Pair<Runnable, Executor>> taskList = new ArrayList<Pair<Runnable, Executor>>();
    private volatile boolean isFinished = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFinishCallback(Runnable runnable, Executor executor) {
        if (!this.isFinished) {
            DefaultCallbackHolder defaultCallbackHolder = this;
            synchronized (defaultCallbackHolder) {
                if (!this.isFinished) {
                    this.taskList.add((Pair<Runnable, Executor>)Pair.of((Object)runnable, (Object)executor));
                    return;
                }
            }
        }
        this.process(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinish() {
        if (!this.isFinished) {
            DefaultCallbackHolder defaultCallbackHolder = this;
            synchronized (defaultCallbackHolder) {
                if (!this.isFinished) {
                    for (Pair<Runnable, Executor> pair : this.taskList) {
                        this.process((Runnable)pair.getKey(), (Executor)pair.getValue());
                    }
                    this.isFinished = true;
                }
            }
        }
    }

    private void process(Runnable runnable, Executor executor) {
        if (executor == null) {
            executor = AsyncUtil.getDefaultCallbackExecutor();
        }
        try {
            executor.execute(runnable);
        }
        catch (Exception e) {
            LoggerUtil.error("Callbackable response exec callback task error, e: ", e);
        }
    }
}

