/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.proxy.AbstractRefererHandler;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;

public class RefererInvocationHandler<T>
extends AbstractRefererHandler<T>
implements InvocationHandler {
    public RefererInvocationHandler(Class<T> clz, List<Caller<T>> callers) {
        this.clz = clz;
        this.callers = callers;
        this.init();
        this.interfaceName = MotanFrameworkUtil.removeAsyncSuffix(clz.getName());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isLocalMethod(method)) {
            if ("toString".equals(method.getName())) {
                return this.clustersToString();
            }
            if ("equals".equals(method.getName())) {
                return this.proxyEquals(args[0]);
            }
            if ("hashCode".equals(method.getName())) {
                return this.callers == null ? 0 : this.callers.hashCode();
            }
            throw new MotanServiceException("can not invoke local method:" + method.getName());
        }
        DefaultRequest request = new DefaultRequest();
        boolean async = this.fillDefaultRequest(request, method, args);
        return this.invokeRequest(request, this.getRealReturnType(async, this.clz, method, request.getMethodName()), async);
    }

    private String clustersToString() {
        StringBuilder sb = new StringBuilder();
        for (Caller caller : this.callers) {
            sb.append("{protocol:").append(caller.getUrl().getProtocol()).append(",");
            sb.append(caller.toString()).append("}").append(",");
        }
        if (!this.callers.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private boolean proxyEquals(Object o) {
        if (o == null || this.callers == null) {
            return false;
        }
        if (o instanceof List) {
            return this.callers == o;
        }
        return o.equals(this.callers);
    }
}

