/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.AbstractRegistry;
import com.weibo.api.motan.rpc.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DirectRegistry
extends AbstractRegistry {
    private ConcurrentHashMap<URL, Object> subscribeUrls = new ConcurrentHashMap();
    private List<URL> directUrls = new ArrayList<URL>();

    public DirectRegistry(URL url) {
        super(url);
        String address = url.getParameter("address");
        if (address.contains(",")) {
            try {
                String[] directUrlArray;
                for (String directUrl : directUrlArray = address.split(",")) {
                    this.parseDirectUrl(directUrl);
                }
            }
            catch (Exception e) {
                throw new MotanFrameworkException(String.format("parse direct url error, invalid direct registry address %s, address should be ip1:port1,ip2:port2 ...", address));
            }
        } else {
            this.registerDirectUrl(url.getHost(), url.getPort());
        }
    }

    private void parseDirectUrl(String directUrl) {
        String[] ipAndPort = directUrl.split(":");
        String ip = ipAndPort[0];
        Integer port = Integer.parseInt(ipAndPort[1]);
        if (port < 0 || port > 65535) {
            throw new RuntimeException();
        }
        this.registerDirectUrl(ip, port);
    }

    private void registerDirectUrl(String ip, Integer port) {
        URL url = new URL("direct", ip, port, "");
        this.directUrls.add(url);
    }

    private void parseIpAndPort(String directUrl) {
    }

    @Override
    protected void doRegister(URL url) {
    }

    @Override
    protected void doUnregister(URL url) {
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.putIfAbsent(url, 1);
        listener.notify(this.getUrl(), this.doDiscover(url));
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.remove(url);
        listener.notify(this.getUrl(), this.doDiscover(url));
    }

    @Override
    protected List<URL> doDiscover(URL subscribeUrl) {
        return this.createSubscribeUrl(subscribeUrl);
    }

    private List<URL> createSubscribeUrl(URL subscribeUrl) {
        URL url = this.getUrl();
        ArrayList<URL> result = new ArrayList<URL>(this.directUrls.size());
        for (URL directUrl : this.directUrls) {
            URL tmp = subscribeUrl.createCopy();
            tmp.setHost(directUrl.getHost());
            tmp.setPort(directUrl.getPort());
            result.add(tmp);
        }
        return result;
    }

    @Override
    protected void doAvailable(URL url) {
    }

    @Override
    protected void doUnavailable(URL url) {
    }
}

