/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.protocol.rpc.DefaultRpcExporter;
import com.weibo.api.motan.protocol.rpc.DefaultRpcReferer;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.api.motan.transport.TransportException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="motan2")
public class MotanV2Protocol
extends AbstractProtocol {
    public static final String DEFAULT_CODEC = "motan2";
    private ConcurrentHashMap<String, ProviderMessageRouter> ipPort2RequestRouter = new ConcurrentHashMap();

    @Override
    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        String codec = url.getParameter(URLParamType.codec.getName());
        if (StringUtils.isBlank((CharSequence)codec) || codec.equals("compressMotan") || codec.equals("motan")) {
            url.getParameters().put(URLParamType.codec.getName(), "motan-compatible");
        }
        return new DefaultRpcExporter<T>(provider, url, this.ipPort2RequestRouter, this.exporterMap);
    }

    @Override
    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        this.setDefaultCodec(url);
        return new V2RpcReferer<T>(clz, url, serviceUrl);
    }

    private void setDefaultCodec(URL url) {
        String codec = url.getParameter(URLParamType.codec.getName());
        if (StringUtils.isBlank((CharSequence)codec) || codec.equals("compressMotan")) {
            url.getParameters().put(URLParamType.codec.getName(), DEFAULT_CODEC);
        }
    }

    class V2RpcReferer<T>
    extends DefaultRpcReferer<T> {
        public V2RpcReferer(Class<T> clz, URL url, URL serviceUrl) {
            super(clz, url, serviceUrl);
        }

        @Override
        protected Response doCall(Request request) {
            try {
                request.setAttachment(URLParamType.group.getName(), this.serviceUrl.getGroup());
                request.setAttachment("M_pp", this.url.getProtocol());
                return this.client.request(request);
            }
            catch (TransportException exception) {
                throw new MotanServiceException("DefaultRpcReferer call Error: url=" + this.url.getUri(), exception);
            }
        }
    }
}

