/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="globalDynamicFilter")
@Activation(sequence=25, key={"service", "referer"})
public class GlobalDynamicFilter
implements Filter {
    private static volatile ConditionFilter dynamicFilter;

    @Override
    public Response filter(Caller<?> caller, Request request) {
        ConditionFilter temp = dynamicFilter;
        if (temp != null) {
            return temp.filter(caller, request);
        }
        return caller.call(request);
    }

    public static synchronized ConditionFilter setDynamicFilter(ConditionFilter conditionFilter) {
        ConditionFilter old = dynamicFilter;
        dynamicFilter = conditionFilter;
        LoggerUtil.info("[GlobalDynamicFilter] setDynamicFilter: " + (conditionFilter == null ? "null" : conditionFilter.toString()) + ", old: " + (old == null ? "null" : old.toString()));
        return old;
    }

    public static ConditionFilter getDynamicFilter() {
        return dynamicFilter;
    }

    public static class Condition {
        public static final String SIDE_SERVER = "server";
        public static final String SIDE_CLIENT = "client";
        private String side;
        private String service;
        private String method;
        private String ip;
        private Pattern servicePattern;
        private Pattern methodPattern;

        public static Condition build(String jsonString) {
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                return new Condition();
            }
            JSONObject jsonObject = JSON.parseObject((String)jsonString);
            return new Condition(jsonObject.getString("side"), jsonObject.getString("service"), jsonObject.getString("method"), jsonObject.getString("ip"));
        }

        public Condition() {
        }

        public Condition(String side, String service, String method, String ip) {
            this.side = side;
            this.service = service;
            this.method = method;
            this.ip = ip;
            this.servicePattern = StringUtils.isBlank((CharSequence)service) ? null : Pattern.compile(service);
            this.methodPattern = StringUtils.isBlank((CharSequence)method) ? null : Pattern.compile(method);
        }

        public boolean match(Caller<?> caller, Request request) {
            boolean isServerSide = caller instanceof Provider;
            if (SIDE_SERVER.equals(this.side) && !isServerSide || SIDE_CLIENT.equals(this.side) && isServerSide) {
                return false;
            }
            if (this.servicePattern != null && !this.servicePattern.matcher(request.getInterfaceName()).matches()) {
                return false;
            }
            if (this.methodPattern != null && !this.methodPattern.matcher(request.getMethodName()).matches()) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)this.ip)) {
                String remoteIp;
                String string = remoteIp = isServerSide ? MotanFrameworkUtil.getRemoteIpFromRequest(request) : caller.getUrl().getHost();
                if (remoteIp != null && !remoteIp.startsWith(this.ip)) {
                    return false;
                }
            }
            return true;
        }

        public String getSide() {
            return this.side;
        }

        public void setSide(String side) {
            this.side = side;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
            this.servicePattern = StringUtils.isBlank((CharSequence)service) ? null : Pattern.compile(service);
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
            this.methodPattern = StringUtils.isBlank((CharSequence)method) ? null : Pattern.compile(method);
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }

    public static class ConditionFilter
    implements Filter {
        private final Filter innerFilter;
        private final Condition condition;
        private final String filterName;
        private final String conditionString;

        public ConditionFilter(String filterName, String conditionString) {
            if (StringUtils.isBlank((CharSequence)filterName)) {
                throw new MotanServiceException("filter is null");
            }
            Filter filter = ExtensionLoader.getExtensionLoader(Filter.class).getExtension(filterName);
            this.filterName = filterName;
            this.conditionString = conditionString;
            this.innerFilter = filter;
            this.condition = StringUtils.isNotBlank((CharSequence)conditionString) ? Condition.build(conditionString) : null;
        }

        @Override
        public Response filter(Caller<?> caller, Request request) {
            if (this.condition == null || this.condition.match(caller, request)) {
                return this.innerFilter.filter(caller, request);
            }
            return caller.call(request);
        }

        public JSONObject toJson() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("filterName", (Object)this.filterName);
            jsonObject.put("conditionString", (Object)this.conditionString);
            return jsonObject;
        }

        public String toString() {
            return "[filterName:" + this.filterName + ", conditionString:" + this.conditionString + "]";
        }
    }
}

