/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.group;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.group.ClusterGroup;
import com.weibo.api.motan.cluster.group.ClusterSelector;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.util.MathUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultClusterGroup<T>
implements ClusterGroup<T> {
    public static final String BACKUP_CLUSTER_SWITCHER_NAME = "feature.motan.backup.cluster.enable";
    protected static final String NO_REFERER_EXCEPTION_MESSAGE = "No available referers";
    protected static Switcher BACKUP_CLUSTER_SWITCHER = null;
    protected ClusterSelector<T> selector;
    protected Cluster<T> masterCluster;
    protected List<Cluster<T>> backupClusters;
    protected List<Cluster<T>> sandboxClusters;
    protected AtomicInteger backupIndex;

    public DefaultClusterGroup(Cluster<T> masterCluster) {
        this.masterCluster = masterCluster;
    }

    @Override
    public Response call(Request request) {
        Cluster<T> cluster = this.masterCluster;
        if (this.selector != null && (cluster = this.selector.select(request)) == null) {
            throw new MotanServiceException("The ClusterSelector did not find an available Cluster");
        }
        try {
            return cluster.call(request);
        }
        catch (MotanServiceException e) {
            if (this.backupClusters != null && !this.backupClusters.isEmpty() && cluster == this.masterCluster && e.getOriginMessage().contains(NO_REFERER_EXCEPTION_MESSAGE) && MotanSwitcherUtil.isOpen(BACKUP_CLUSTER_SWITCHER, BACKUP_CLUSTER_SWITCHER_NAME)) {
                return this.backupClusters.get(MathUtil.getNonNegative(this.backupIndex.incrementAndGet()) % this.backupClusters.size()).call(request);
            }
            throw e;
        }
    }

    @Override
    public void init() {
        if (this.sandboxClusters != null) {
            this.selector = ExtensionLoader.getExtensionLoader(ClusterSelector.class).getExtension(this.masterCluster.getUrl().getParameter(URLParamType.clusterSelector.getName(), DEFAULT_CLUSTER_SELECTOR));
            this.selector.init(this);
        }
        if (this.backupClusters != null) {
            this.backupIndex = new AtomicInteger();
        }
    }

    @Override
    public void destroy() {
        if (this.selector != null) {
            this.selector.destroy();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.masterCluster.isAvailable();
    }

    @Override
    public Class<T> getInterface() {
        return this.masterCluster.getInterface();
    }

    @Override
    public String desc() {
        return this.masterCluster.desc();
    }

    @Override
    public URL getUrl() {
        return this.masterCluster.getUrl();
    }

    @Override
    public Cluster<T> getMasterCluster() {
        return this.masterCluster;
    }

    @Override
    public List<Cluster<T>> getBackupClusters() {
        return this.backupClusters;
    }

    public void setBackupClusters(List<Cluster<T>> backupClusters) {
        this.backupClusters = backupClusters;
    }

    @Override
    public List<Cluster<T>> getSandboxClusters() {
        return this.sandboxClusters;
    }

    public void setSandboxClusters(List<Cluster<T>> sandboxClusters) {
        this.sandboxClusters = sandboxClusters;
    }

    public String toString() {
        return "DefaultClusterGroup {masterCluster=" + this.clusterToString(this.masterCluster) + ", backupClusters=" + this.clustersToString(this.backupClusters) + ", sandboxClusters=" + this.clustersToString(this.sandboxClusters) + "}";
    }

    private String clustersToString(List<Cluster<T>> clusters) {
        if (clusters == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Cluster<T> cluster : clusters) {
            this.clusterToString(cluster, sb);
            sb.append(",");
        }
        if (clusters.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    private String clusterToString(Cluster<T> cluster) {
        if (cluster == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        this.clusterToString(cluster, sb);
        return sb.toString();
    }

    private void clusterToString(Cluster<T> cluster, StringBuilder sb) {
        if (cluster == null) {
            return;
        }
        List<Referer<T>> referers = cluster.getReferers();
        sb.append("[");
        if (referers != null) {
            for (Referer<T> refer : referers) {
                sb.append("{").append(refer.getUrl().toSimpleString()).append(", available:").append(refer.isAvailable()).append("}").append(",");
            }
            if (referers.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        sb.append("]");
    }

    static {
        if (MotanSwitcherUtil.canHoldSwitcher()) {
            BACKUP_CLUSTER_SWITCHER = MotanSwitcherUtil.getOrInitSwitcher(BACKUP_CLUSTER_SWITCHER_NAME, true);
        } else {
            MotanSwitcherUtil.initSwitcher(BACKUP_CLUSTER_SWITCHER_NAME, true);
        }
    }
}

