/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.admin;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.admin.AdminCommandHandler;
import com.weibo.api.motan.admin.AdminHandler;
import com.weibo.api.motan.admin.DefaultAdminHandler;
import com.weibo.api.motan.admin.DefaultPermissionChecker;
import com.weibo.api.motan.admin.PermissionChecker;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import java.util.Collections;
import java.util.Map;

public class AdminUtil {
    private static final DefaultPermissionChecker DEFAULT_PERMISSION_CHECKER = new DefaultPermissionChecker();
    private static final AdminHandler DEFAULT_ADMIN_HANDLER = new DefaultAdminHandler();

    public static AdminHandler getDefaultAdminHandler() {
        return DEFAULT_ADMIN_HANDLER;
    }

    public static PermissionChecker getDefaultPermissionChecker() {
        return DEFAULT_PERMISSION_CHECKER;
    }

    public static void addCommandHandler(AdminCommandHandler adminCommandHandler) {
        AdminUtil.addCommandHandler(adminCommandHandler, false);
    }

    public static void addCommandHandler(AdminCommandHandler adminCommandHandler, boolean override) {
        DEFAULT_ADMIN_HANDLER.addCommandHandler(adminCommandHandler, override);
    }

    public static void updatePermissionChecker(PermissionChecker permissionChecker) {
        DEFAULT_ADMIN_HANDLER.updatePermissionChecker(permissionChecker);
    }

    public static DefaultResponse buildResponse(Request request, String returnValue) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(request.getRequestId());
        response.setRpcProtocolVersion(request.getRpcProtocolVersion());
        response.setValue(returnValue);
        return response;
    }

    public static DefaultResponse buildErrorResponse(Request request, String errMessage) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(request.getRequestId());
        response.setRpcProtocolVersion(request.getRpcProtocolVersion());
        response.setException(new MotanServiceException(AdminUtil.toJsonErrorMessage(errMessage)));
        return response;
    }

    public static String toJsonErrorMessage(String errMessage) {
        JSONObject errJson = new JSONObject();
        errJson.put("result", (Object)"fail");
        errJson.put("from", (Object)"Motan Admin");
        errJson.put("error", (Object)(errMessage == null ? "null" : errMessage));
        return errJson.toJSONString();
    }

    public static DefaultResponse unknownCommand(Request request) {
        return AdminUtil.buildErrorResponse(request, "unknown command " + request.getMethodName());
    }

    public static DefaultResponse notAllowed(Request request) {
        return AdminUtil.buildErrorResponse(request, "not allowed");
    }

    public static Map<String, String> getParams(Request request) {
        if (request.getArguments() == null || request.getArguments().length < 1 || !(request.getArguments()[0] instanceof Map)) {
            return Collections.emptyMap();
        }
        return (Map)request.getArguments()[0];
    }
}

