/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.runtime;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.transport.MeshClient;
import com.weibo.api.motan.transport.Server;
import com.weibo.api.motan.util.MetaUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalRuntime {
    private static final ConcurrentHashMap<String, Registry> runtimeRegistries = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Exporter<?>> runtimeExporters = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Cluster<?>> runtimeClusters = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, MeshClient> runtimeMeshClients = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Server> runtimeServers = new ConcurrentHashMap();
    private static final Map<String, String> envMeta;
    private static final ConcurrentHashMap<String, String> dynamicMeta;

    public static void addRegistry(String id, Registry registry) {
        runtimeRegistries.put(id, registry);
    }

    public static Registry removeRegistry(String id) {
        return runtimeRegistries.remove(id);
    }

    public static Map<String, Registry> getRuntimeRegistries() {
        return Collections.unmodifiableMap(runtimeRegistries);
    }

    public static void addExporter(String id, Exporter<?> exporter) {
        runtimeExporters.put(id, exporter);
    }

    public static Exporter<?> removeExporter(String id) {
        return runtimeExporters.remove(id);
    }

    public static Map<String, Exporter<?>> getRuntimeExporters() {
        return Collections.unmodifiableMap(runtimeExporters);
    }

    public static void addCluster(String id, Cluster<?> cluster) {
        runtimeClusters.put(id, cluster);
    }

    public static Cluster<?> removeCluster(String id) {
        return runtimeClusters.remove(id);
    }

    public static Map<String, Cluster<?>> getRuntimeClusters() {
        return Collections.unmodifiableMap(runtimeClusters);
    }

    public static void addMeshClient(String id, MeshClient meshClient) {
        runtimeMeshClients.put(id, meshClient);
    }

    public static MeshClient removeMeshClient(String id) {
        return runtimeMeshClients.remove(id);
    }

    public static Map<String, MeshClient> getRuntimeMeshClients() {
        return Collections.unmodifiableMap(runtimeMeshClients);
    }

    public static void addServer(String id, Server server) {
        runtimeServers.put(id, server);
    }

    public static Server removeServer(String id) {
        return runtimeServers.remove(id);
    }

    public static Map<String, Server> getRuntimeServers() {
        return Collections.unmodifiableMap(runtimeServers);
    }

    public static Map<String, String> getEnvMeta() {
        return envMeta;
    }

    public static void putDynamicMeta(String key, String value) {
        dynamicMeta.put(key, value);
    }

    public static void removeDynamicMeta(String key) {
        dynamicMeta.remove(key);
    }

    public static Map<String, String> getDynamicMeta() {
        return dynamicMeta;
    }

    public static Map<String, String> getMergedMeta() {
        HashMap<String, String> currentMeta = new HashMap<String, String>();
        currentMeta.putAll(envMeta);
        currentMeta.putAll(dynamicMeta);
        return currentMeta;
    }

    static {
        dynamicMeta = new ConcurrentHashMap();
        envMeta = Collections.unmodifiableMap(MetaUtil._getOriginMetaInfoFromEnv());
    }
}

