/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.cluster.loadbalance.Selector;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class GroupWeightLoadBalanceWrapper<T>
extends AbstractLoadBalance<T> {
    volatile Selector<T> selector;
    private String weightString;
    private final String loadBalanceName;

    public GroupWeightLoadBalanceWrapper(String loadBalanceName) {
        this.loadBalanceName = loadBalanceName;
    }

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        String selectorName;
        super.onRefresh(referers, false);
        Selector<T> oldSelector = null;
        boolean reuse = false;
        if (StringUtils.isEmpty((CharSequence)this.weightString)) {
            selectorName = "SingleGroupSelector";
            if (this.selector instanceof SingleGroupSelector) {
                ((SingleGroupSelector)this.selector).refresh(referers);
                reuse = true;
            } else {
                oldSelector = this.selector;
                this.selector = new SingleGroupSelector<T>(this.clusterUrl, referers, this.loadBalanceName);
            }
        } else {
            selectorName = "MultiGroupSelector";
            if (this.selector instanceof MultiGroupSelector) {
                ((MultiGroupSelector)this.selector).refresh(referers, this.weightString);
                reuse = true;
            } else {
                oldSelector = this.selector;
                this.selector = new MultiGroupSelector<T>(this.clusterUrl, referers, this.loadBalanceName, this.weightString);
            }
        }
        LoggerUtil.info("GroupWeightLoadBalance onRefresh use " + selectorName + ". reuse selector: " + reuse + ", url:" + this.clusterUrl.toSimpleString());
        if (oldSelector != null) {
            oldSelector.destroy();
        }
    }

    @Override
    public boolean canSelectMulti() {
        return false;
    }

    @Override
    protected Referer<T> doSelect(Request request) {
        if (this.selector == null) {
            return null;
        }
        return this.selector.select(request);
    }

    @Override
    public void destroy() {
        if (this.selector != null) {
            this.selector.destroy();
            this.selector = null;
        }
    }

    @Override
    public void setWeightString(String weightString) {
        this.weightString = weightString;
    }

    private static class InnerSelector<T>
    implements Selector<T> {
        final ConcurrentHashMap<String, LoadBalance<T>> lbMap;
        final byte[] groupWeightRing;
        final LoadBalance<T>[] lbArray;
        final AtomicInteger index = new AtomicInteger(0);

        public InnerSelector(ConcurrentHashMap<String, LoadBalance<T>> lbMap, byte[] groupWeightRing, LoadBalance<T>[] lbArray) {
            this.lbMap = lbMap;
            this.groupWeightRing = groupWeightRing;
            this.lbArray = lbArray;
        }

        @Override
        public Referer<T> select(Request request) {
            return this.lbArray[this.getLBIndex(MathUtil.getNonNegative(this.index.getAndIncrement()))].select(request);
        }

        @Override
        public void destroy() {
            for (LoadBalance<T> lb : this.lbArray) {
                lb.destroy();
            }
        }

        private int getLBIndex(int ringIndex) {
            int lbIndex = this.groupWeightRing[ringIndex % this.groupWeightRing.length];
            if (lbIndex < 0) {
                lbIndex += 256;
            }
            return lbIndex;
        }
    }

    static class MultiGroupSelector<T>
    implements Selector<T> {
        private final URL clusterUrl;
        private final String loadBalanceName;
        private List<Referer<T>> referers;
        private String weightString;
        private volatile InnerSelector<T> innerSelector;

        public MultiGroupSelector(URL clusterUrl, List<Referer<T>> referers, String loadBalanceName, String weightString) {
            this.referers = referers;
            this.clusterUrl = clusterUrl;
            this.loadBalanceName = loadBalanceName;
            this.weightString = weightString;
            this.reBuildInnerSelector();
        }

        @Override
        public Referer<T> select(Request request) {
            if (this.innerSelector == null) {
                return null;
            }
            return this.innerSelector.select(request);
        }

        public synchronized void refresh(List<Referer<T>> referers, String weightString) {
            this.referers = referers;
            if (this.weightString.equals(weightString)) {
                Map<String, List<Referer<T>>> groupReferers = this.getGroupReferers(referers);
                for (String groupName : groupReferers.keySet()) {
                    LoadBalance<T> loadBalance = this.innerSelector.lbMap.get(groupName);
                    if (loadBalance != null) {
                        loadBalance.onRefresh(groupReferers.get(groupName));
                        continue;
                    }
                    LoggerUtil.warn("GroupWeightLoadBalance groupName:{} not exist in innerSelector.lbMap", groupName);
                }
            } else {
                this.weightString = weightString;
                this.reBuildInnerSelector();
            }
        }

        private void reBuildInnerSelector() {
            Map<String, List<Referer<T>>> groupReferers = this.getGroupReferers(this.referers);
            String[] groupsAndWeights = this.weightString.split(",");
            if (groupsAndWeights.length > 256) {
                throw new MotanFrameworkException("the group in weightString is greater than 256");
            }
            int[] weightsArr = new int[groupsAndWeights.length];
            LoadBalance[] lbArray = new LoadBalance[groupsAndWeights.length];
            ConcurrentHashMap lbMap = new ConcurrentHashMap();
            int totalWeight = 0;
            for (int i = 0; i < groupsAndWeights.length; ++i) {
                String[] gw = groupsAndWeights[i].split(":");
                weightsArr[i] = Integer.parseInt(gw[1]);
                totalWeight += weightsArr[i];
                lbArray[i] = this.reuseOrCreateLB(gw[0], groupReferers.get(gw[0]));
                lbMap.put(gw[0], lbArray[i]);
            }
            int weightGcd = MathUtil.findGCD(weightsArr);
            if (weightGcd > 1) {
                totalWeight = 0;
                for (int i = 0; i < weightsArr.length; ++i) {
                    weightsArr[i] = weightsArr[i] / weightGcd;
                    totalWeight += weightsArr[i];
                }
            }
            byte[] groupWeightRing = new byte[totalWeight];
            int index = 0;
            for (int i = 0; i < weightsArr.length; ++i) {
                for (int j = 0; j < weightsArr[i]; ++j) {
                    groupWeightRing[index++] = (byte)i;
                }
            }
            CollectionUtil.shuffleByteArray(groupWeightRing);
            ConcurrentHashMap remain = this.innerSelector == null ? null : this.innerSelector.lbMap;
            this.innerSelector = new InnerSelector(lbMap, groupWeightRing, lbArray);
            if (remain != null) {
                for (LoadBalance lb : remain.values()) {
                    try {
                        lb.destroy();
                    }
                    catch (Exception e) {
                        LoggerUtil.warn("GroupWeightLoadBalance destroy lb fail. url:" + this.clusterUrl.toSimpleString() + " error: " + e.getMessage());
                    }
                }
            }
        }

        private LoadBalance<T> reuseOrCreateLB(String group, List<Referer<T>> groupReferers) {
            LoadBalance loadBalance = null;
            if (this.innerSelector != null) {
                loadBalance = this.innerSelector.lbMap.remove(group);
            }
            if (loadBalance == null) {
                loadBalance = ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(this.loadBalanceName);
                loadBalance.init(this.clusterUrl);
            }
            loadBalance.onRefresh(groupReferers);
            return loadBalance;
        }

        private Map<String, List<Referer<T>>> getGroupReferers(List<Referer<T>> referers) {
            HashMap<String, List<Referer<T>>> result = new HashMap<String, List<Referer<T>>>();
            for (Referer<T> referer : referers) {
                result.computeIfAbsent(referer.getUrl().getGroup(), k -> new ArrayList()).add(referer);
            }
            return result;
        }

        @Override
        public void destroy() {
            this.referers = null;
            if (this.innerSelector != null) {
                this.innerSelector.destroy();
                this.innerSelector = null;
            }
        }
    }

    static class SingleGroupSelector<T>
    implements Selector<T> {
        private final LoadBalance<T> loadBalance;

        public SingleGroupSelector(URL clusterUrl, List<Referer<T>> referers, String loadBalanceName) {
            this.loadBalance = ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(loadBalanceName);
            this.loadBalance.init(clusterUrl);
            this.loadBalance.onRefresh(referers);
        }

        @Override
        public Referer<T> select(Request request) {
            return this.loadBalance.select(request);
        }

        public void refresh(List<Referer<T>> referers) {
            this.loadBalance.onRefresh(referers);
        }

        @Override
        public void destroy() {
            this.loadBalance.destroy();
        }
    }
}

