/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.AbstractNode;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractReferer<T>
extends AbstractNode
implements Referer<T> {
    protected Class<T> clz;
    protected AtomicInteger activeRefererCount = new AtomicInteger(0);
    protected URL serviceUrl;

    public AbstractReferer(Class<T> clz, URL url) {
        super(url);
        this.clz = clz;
        this.serviceUrl = url;
    }

    public AbstractReferer(Class<T> clz, URL url, URL serviceUrl) {
        super(url);
        this.clz = clz;
        this.serviceUrl = serviceUrl;
    }

    @Override
    public Class<T> getInterface() {
        return this.clz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call(Request request) {
        if (!this.isAvailable()) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " call Error: node is not available, url=" + this.url.getUri() + " " + MotanFrameworkUtil.toString(request));
        }
        this.incrActiveCount(request);
        Response response = null;
        try {
            Response response2 = response = this.doCall(request);
            return response2;
        }
        finally {
            this.decrActiveCount(request, response);
        }
    }

    @Override
    public int activeRefererCount() {
        return this.activeRefererCount.get();
    }

    protected void incrActiveCount(Request request) {
        this.activeRefererCount.incrementAndGet();
    }

    protected void decrActiveCount(Request request, Response response) {
        this.activeRefererCount.decrementAndGet();
    }

    protected abstract Response doCall(Request var1);

    @Override
    public String desc() {
        return "[" + this.getClass().getSimpleName() + "] url=" + this.url;
    }

    @Override
    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public Map<String, Object> getRuntimeInfo() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("currentCallCount", this.activeRefererCount.get());
        return infos;
    }
}

