/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.FutureState;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.FutureListener;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultResponseFuture
implements ResponseFuture {
    protected volatile FutureState state = FutureState.DOING;
    protected final Object lock = new Object();
    protected Object result = null;
    protected Exception exception = null;
    protected long createTime = System.currentTimeMillis();
    protected int timeout = 0;
    protected long processTime = 0L;
    protected Request request;
    protected List<FutureListener> listeners;
    protected URL serverUrl;
    protected Class returnType;

    public DefaultResponseFuture(Request requestObj, int timeout, URL serverUrl) {
        this.request = requestObj;
        this.timeout = timeout;
        this.serverUrl = serverUrl;
    }

    @Override
    public void onSuccess(Response response) {
        this.result = response.getValue();
        this.processTime = response.getProcessTime();
        this.done();
    }

    @Override
    public void onFailure(Response response) {
        this.exception = response.getException();
        this.processTime = response.getProcessTime();
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return this.getValueOrThrowable();
            }
            if (this.timeout <= 0) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    this.cancel(new MotanServiceException(this.getClass().getName() + " getValue InterruptedException : " + MotanFrameworkUtil.toString(this.request) + " cost=" + (System.currentTimeMillis() - this.createTime), e));
                }
                return this.getValueOrThrowable();
            }
            long waitTime = (long)this.timeout - (System.currentTimeMillis() - this.createTime);
            if (waitTime > 0L) {
                do {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.isDoing() && (waitTime = (long)this.timeout - (System.currentTimeMillis() - this.createTime)) > 0L);
            }
            if (this.isDoing()) {
                this.timeoutSoCancel();
            }
            return this.getValueOrThrowable();
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public boolean cancel() {
        MotanServiceException e = new MotanServiceException(this.getClass().getName() + " task cancel: serverPort=" + this.serverUrl.getServerPortStr() + " " + MotanFrameworkUtil.toString(this.request) + " cost=" + (System.currentTimeMillis() - this.createTime));
        return this.cancel(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancel(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.CANCELLED;
            this.exception = e;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state.isCancelledState();
    }

    @Override
    public boolean isDone() {
        return this.state.isDoneState();
    }

    @Override
    public boolean isSuccess() {
        return this.isDone() && this.exception == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("FutureListener is null");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                notifyNow = true;
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<FutureListener>(1);
                }
                this.listeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setReturnType(Class<?> clazz) {
        this.returnType = clazz;
    }

    public Object getRequestObj() {
        return this.request;
    }

    public FutureState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutSoCancel() {
        this.processTime = System.currentTimeMillis() - this.createTime;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return;
            }
            this.state = FutureState.CANCELLED;
            this.exception = new MotanServiceException(this.getClass().getName() + " request timeout: serverPort=" + this.serverUrl.getServerPortStr() + " " + MotanFrameworkUtil.toString(this.request) + " cost=" + (System.currentTimeMillis() - this.createTime), MotanErrorMsgConstant.SERVICE_TIMEOUT);
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            for (FutureListener listener : this.listeners) {
                this.notifyListener(listener);
            }
        }
    }

    private void notifyListener(FutureListener listener) {
        try {
            listener.operationComplete(this);
        }
        catch (Throwable t) {
            LoggerUtil.error(this.getClass().getName() + " notifyListener Error: " + listener.getClass().getSimpleName(), t);
        }
    }

    private boolean isDoing() {
        return this.state.isDoingState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean done() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.DONE;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }

    @Override
    public long getRequestId() {
        return this.request.getRequestId();
    }

    private Object getValueOrThrowable() {
        if (this.exception != null) {
            throw this.exception instanceof RuntimeException ? (RuntimeException)this.exception : new MotanServiceException(this.exception.getMessage(), this.exception);
        }
        if (this.result != null && this.returnType != null && this.result instanceof DeserializableObject) {
            try {
                this.result = ((DeserializableObject)this.result).deserialize(this.returnType);
            }
            catch (IOException e) {
                LoggerUtil.error("deserialize response value fail! return type:" + this.returnType, e);
                throw new MotanFrameworkException("deserialize return value fail! deserialize type:" + this.returnType, e);
            }
        }
        return this.result;
    }

    @Override
    public long getProcessTime() {
        return this.processTime;
    }

    @Override
    public void setProcessTime(long time) {
        this.processTime = time;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Map<String, String> getAttachments() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void setAttachment(String key, String value) {
    }

    @Override
    public void setRpcProtocolVersion(byte rpcProtocolVersion) {
    }

    @Override
    public byte getRpcProtocolVersion() {
        return RpcProtocolVersion.VERSION_1.getVersion();
    }
}

