/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.rpc.TraceableRequest;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractTraceableRequest
implements TraceableRequest {
    private List<Pair<Runnable, Executor>> taskList = new ArrayList<Pair<Runnable, Executor>>();
    private ConcurrentHashMap<String, String> traceInfoMap = new ConcurrentHashMap();
    private AtomicBoolean isFinished = new AtomicBoolean();
    private AtomicLong startTime = new AtomicLong();
    private AtomicLong endTime = new AtomicLong();

    @Override
    public long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime.compareAndSet(0L, startTime);
    }

    @Override
    public long getEndTime() {
        return this.endTime.get();
    }

    @Override
    public void addTraceInfo(String key, String value) {
        this.traceInfoMap.put(key, value);
    }

    @Override
    public String getTraceInfo(String key) {
        return this.traceInfoMap.get(key);
    }

    @Override
    public void addFinishCallback(Runnable runnable, Executor executor) {
        if (!this.isFinished.get()) {
            this.taskList.add((Pair<Runnable, Executor>)Pair.of((Object)runnable, (Object)executor));
        }
    }

    @Override
    public void onFinish() {
        if (!this.isFinished.compareAndSet(false, true)) {
            return;
        }
        this.endTime.set(System.currentTimeMillis());
        for (Pair<Runnable, Executor> pair : this.taskList) {
            Runnable runnable = (Runnable)pair.getKey();
            Executor executor = (Executor)pair.getValue();
            if (executor == null) {
                runnable.run();
                continue;
            }
            try {
                executor.execute(runnable);
            }
            catch (Exception e) {
                LoggerUtil.error("TraceableRequest exec callback task error, e: ", e);
            }
        }
    }
}

