/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import com.weibo.api.motan.codec.AbstractCodec;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.v2motan.GrowableByteBuffer;
import com.weibo.api.motan.protocol.v2motan.MotanV2Header;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.support.DefaultRpcHeartbeatFactory;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="motan2")
public class MotanV2Codec
extends AbstractCodec {
    private static final byte MASK = 7;
    private static final int HEADER_SIZE = 13;

    @Override
    public byte[] encode(Channel channel, Object message) throws IOException {
        try {
            if (DefaultRpcHeartbeatFactory.isHeartbeatRequest(message)) {
                return this.encodeHeartbeat(((Request)message).getRequestId(), true);
            }
            if (DefaultRpcHeartbeatFactory.isHeartbeatResponse(message)) {
                return this.encodeHeartbeat(((Response)message).getRequestId(), false);
            }
            MotanV2Header header = new MotanV2Header();
            byte[] body = null;
            String serialName = channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue());
            Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(serialName);
            if (serialization == null) {
                throw new MotanServiceException("can not found serialization " + serialName);
            }
            header.setSerialize(serialization.getSerializationNumber());
            GrowableByteBuffer buf = new GrowableByteBuffer(4096);
            int index = 13;
            buf.position(index);
            buf.putInt(0);
            if (message instanceof Request) {
                Request request = (Request)message;
                this.putString(buf, "M_p");
                this.putString(buf, request.getInterfaceName());
                this.putString(buf, "M_m");
                this.putString(buf, request.getMethodName());
                if (request.getParamtersDesc() != null) {
                    this.putString(buf, "M_md");
                    this.putString(buf, request.getParamtersDesc());
                }
                if (request.getAttachments() != null && request.getAttachments().get(URLParamType.group.getName()) != null) {
                    request.setAttachment("M_g", request.getAttachments().get(URLParamType.group.getName()));
                }
                this.putMap(buf, request.getAttachments());
                header.setRequestId(request.getRequestId());
                if (request.getArguments() != null) {
                    body = serialization.serializeMulti(request.getArguments());
                }
            } else if (message instanceof Response) {
                Response response = (Response)message;
                this.putString(buf, "M_pt");
                this.putString(buf, String.valueOf(response.getProcessTime()));
                if (response.getException() != null) {
                    this.putString(buf, "M_e");
                    this.putString(buf, ExceptionUtil.toMessage(response.getException()));
                    header.setStatus(MotanV2Header.MessageStatus.EXCEPTION.getStatus());
                }
                this.putMap(buf, response.getAttachments());
                header.setRequestId(response.getRequestId());
                header.setRequest(false);
                if (response.getException() == null) {
                    body = serialization.serialize(response.getValue());
                }
            }
            buf.position(buf.position() - 1);
            int metalength = buf.position() - index - 4;
            buf.putInt(index, metalength);
            if (body != null && body.length > 0) {
                if (channel.getUrl().getBooleanParameter(URLParamType.usegz.getName(), URLParamType.usegz.getBooleanValue()).booleanValue() && body.length > channel.getUrl().getIntParameter(URLParamType.mingzSize.getName(), URLParamType.mingzSize.getIntValue())) {
                    try {
                        body = ByteUtil.gzip(body);
                        header.setGzip(true);
                    }
                    catch (IOException e) {
                        LoggerUtil.warn("MotanV2Codec encode gzip fail. so not gzip body.", e);
                    }
                }
                buf.putInt(body.length);
                buf.put(body);
            } else {
                buf.putInt(0);
            }
            int position = buf.position();
            buf.position(0);
            buf.put(header.toBytes());
            buf.position(position);
            buf.flip();
            byte[] result = new byte[buf.remaining()];
            buf.get(result);
            return result;
        }
        catch (Exception e) {
            String errmsg = "";
            if (message != null) {
                errmsg = message instanceof Request ? "type:request, " + message.toString() : "type:response, " + message.toString();
            }
            LoggerUtil.warn("motan2 encode error." + errmsg, e);
            if (ExceptionUtil.isMotanException(e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("encode error!" + errmsg + ", origin errmsg:" + e.getMessage(), e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
    }

    private void putString(GrowableByteBuffer buf, String content) throws UnsupportedEncodingException {
        buf.put(content.getBytes("UTF-8"));
        buf.put("\n".getBytes("UTF-8"));
    }

    private void putMap(GrowableByteBuffer buf, Map<String, String> map) throws UnsupportedEncodingException {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.putString(buf, entry.getKey());
                this.putString(buf, entry.getValue());
            }
        }
    }

    private byte[] encodeHeartbeat(long requestId, boolean isRequest) {
        MotanV2Header header = new MotanV2Header();
        header.setHeartbeat(true);
        header.setRequestId(requestId);
        if (!isRequest) {
            header.setRequest(false);
        }
        GrowableByteBuffer buf = new GrowableByteBuffer(32);
        buf.put(header.toBytes());
        buf.putInt(0);
        buf.putInt(0);
        buf.flip();
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        return result;
    }

    @Override
    public Object decode(Channel channel, String remoteIp, byte[] data) throws IOException {
        MotanV2Header header = MotanV2Header.buildHeader(data);
        Map<Object, Object> metaMap = new HashMap();
        ByteBuffer buf = ByteBuffer.wrap(data);
        int metaSize = buf.getInt(13);
        int index = 17;
        if (metaSize > 0) {
            byte[] meta = new byte[metaSize];
            buf.position(index);
            buf.get(meta);
            metaMap = this.decodeMeta(meta);
            index += metaSize;
        }
        int bodySize = buf.getInt(index);
        index += 4;
        DeserializableObject obj = null;
        if (bodySize > 0) {
            byte[] body = new byte[bodySize];
            buf.position(index);
            buf.get(body);
            if (header.isGzip()) {
                body = ByteUtil.unGzip(body);
            }
            Serialization serialization = this.getSerializationByNum(header.getSerialize());
            obj = new DeserializableObject(serialization, body);
        }
        if (header.isRequest()) {
            if (header.isHeartbeat()) {
                return DefaultRpcHeartbeatFactory.getDefaultHeartbeatRequest(header.getRequestId());
            }
            DefaultRequest request = new DefaultRequest();
            request.setRequestId(header.getRequestId());
            request.setInterfaceName((String)metaMap.remove("M_p"));
            request.setMethodName((String)metaMap.remove("M_m"));
            request.setParamtersDesc((String)metaMap.remove("M_md"));
            request.setAttachments(metaMap);
            if (obj != null) {
                request.setArguments(new Object[]{obj});
            }
            if (metaMap.get("M_g") != null) {
                request.setAttachment(URLParamType.group.getName(), (String)metaMap.get("M_g"));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)metaMap.get("M_v")))) {
                request.setAttachment(URLParamType.version.getName(), (String)metaMap.get("M_v"));
            }
            return request;
        }
        if (header.isHeartbeat()) {
            return DefaultRpcHeartbeatFactory.getDefaultHeartbeatResponse(header.getRequestId());
        }
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(header.getRequestId());
        response.setProcessTime(MathUtil.parseLong((String)metaMap.remove("M_pt"), 0L));
        response.setAttachments(metaMap);
        if (header.getStatus() == MotanV2Header.MessageStatus.NORMAL.getStatus()) {
            response.setValue(obj);
        } else {
            String errmsg = (String)metaMap.remove("M_e");
            MotanAbstractException e = ExceptionUtil.fromMessage(errmsg);
            if (e == null) {
                e = new MotanServiceException("default remote exception. remote errmsg:" + errmsg);
            }
            response.setException(e);
        }
        return response;
    }

    private Map<String, String> decodeMeta(byte[] meta) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (meta != null && meta.length > 0) {
            String[] s = new String(meta).split("\n");
            for (int i = 0; i < s.length - 1; ++i) {
                map.put(s[i++], s[i]);
            }
        }
        return map;
    }

    static {
        MotanV2Codec.initAllSerialization();
    }
}

