/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.support;

import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.ActivationComparator;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.filter.InitializableFilter;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProtocolFilterDecorator
implements Protocol {
    private Protocol protocol;

    public ProtocolFilterDecorator(Protocol protocol) {
        if (protocol == null) {
            throw new MotanFrameworkException("Protocol is null when construct ProtocolFilterDecorator", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.protocol = protocol;
    }

    @Override
    public <T> Exporter<T> export(Provider<T> provider, URL url) {
        return this.protocol.export(this.decorateWithFilter(provider, url), url);
    }

    @Override
    public <T> Referer<T> refer(Class<T> clz, URL url, URL serviceUrl) {
        return this.decorateWithFilter(this.protocol.refer(clz, url, serviceUrl), url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    private <T> Referer<T> decorateWithFilter(Referer<T> referer, URL url) {
        List<Filter> filters = this.getFilters(url, "referer");
        Referer lastRef = referer;
        for (Filter filter : filters) {
            final Filter f = filter;
            if (f instanceof InitializableFilter) {
                ((InitializableFilter)f).init(lastRef);
            }
            final Referer lf = lastRef;
            lastRef = new Referer<T>(){

                @Override
                public Response call(Request request) {
                    Activation activation = f.getClass().getAnnotation(Activation.class);
                    if (activation != null && !activation.retry() && request.getRetries() != 0) {
                        return lf.call(request);
                    }
                    return f.filter(lf, request);
                }

                @Override
                public String desc() {
                    return lf.desc();
                }

                @Override
                public void destroy() {
                    lf.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lf.getInterface();
                }

                @Override
                public URL getUrl() {
                    return lf.getUrl();
                }

                @Override
                public void init() {
                    lf.init();
                }

                @Override
                public boolean isAvailable() {
                    return lf.isAvailable();
                }

                @Override
                public int activeRefererCount() {
                    return lf.activeRefererCount();
                }

                @Override
                public URL getServiceUrl() {
                    return lf.getServiceUrl();
                }
            };
        }
        return lastRef;
    }

    private <T> Provider<T> decorateWithFilter(final Provider<T> provider, URL url) {
        List<Filter> filters = this.getFilters(url, "service");
        if (filters == null || filters.size() == 0) {
            return provider;
        }
        Provider lastProvider = provider;
        for (Filter filter : filters) {
            final Filter f = filter;
            if (f instanceof InitializableFilter) {
                ((InitializableFilter)f).init(lastProvider);
            }
            final Provider lp = lastProvider;
            lastProvider = new Provider<T>(){

                @Override
                public Response call(Request request) {
                    return f.filter(lp, request);
                }

                @Override
                public String desc() {
                    return lp.desc();
                }

                @Override
                public void destroy() {
                    lp.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lp.getInterface();
                }

                @Override
                public Method lookupMethod(String methodName, String methodDesc) {
                    return lp.lookupMethod(methodName, methodDesc);
                }

                @Override
                public URL getUrl() {
                    return lp.getUrl();
                }

                @Override
                public void init() {
                    lp.init();
                }

                @Override
                public boolean isAvailable() {
                    return lp.isAvailable();
                }

                @Override
                public T getImpl() {
                    return provider.getImpl();
                }
            };
        }
        return lastProvider;
    }

    private List<Filter> getFilters(URL url, String key) {
        String filterStr;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        List<Filter> defaultFilters = ExtensionLoader.getExtensionLoader(Filter.class).getExtensions(key);
        if (defaultFilters != null && defaultFilters.size() > 0) {
            filters.addAll(defaultFilters);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterStr = url.getParameter(URLParamType.filter.getName())))) {
            String[] filterNames;
            for (String fn : filterNames = MotanConstants.COMMA_SPLIT_PATTERN.split(filterStr)) {
                this.addIfAbsent(filters, fn);
            }
        }
        Collections.sort(filters, new ActivationComparator());
        Collections.reverse(filters);
        return filters;
    }

    private void addIfAbsent(List<Filter> filters, String extensionName) {
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            return;
        }
        Filter extFilter = ExtensionLoader.getExtensionLoader(Filter.class).getExtension(extensionName, false);
        if (extFilter == null) {
            LoggerUtil.warn("filter extension not found. filer name: " + extensionName);
            return;
        }
        boolean exists = false;
        for (Filter f : filters) {
            if (f.getClass() != extFilter.getClass()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            filters.add(extFilter);
        }
    }
}

