/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.StringTools;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="access")
@Activation(sequence=100, key={"service", "referer"})
public class AccessLogFilter
implements Filter {
    public static final String ACCESS_LOG_SWITCHER_NAME = "feature.motan.filter.accessLog";
    private String side;
    private Boolean accessLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response filter(Caller<?> caller, Request request) {
        if (this.accessLog == null) {
            this.accessLog = caller.getUrl().getBooleanParameter(URLParamType.accessLog.getName(), URLParamType.accessLog.getBooleanValue());
        }
        if (this.accessLog.booleanValue() || MotanSwitcherUtil.isOpen(ACCESS_LOG_SWITCHER_NAME)) {
            long t1 = System.currentTimeMillis();
            boolean success = false;
            try {
                Response response = caller.call(request);
                success = true;
                Response response2 = response;
                return response2;
            }
            finally {
                long consumeTime = System.currentTimeMillis() - t1;
                this.logAccess(caller, request, consumeTime, success);
            }
        }
        return caller.call(request);
    }

    private void logAccess(Caller<?> caller, Request request, long consumeTime, boolean success) {
        if (this.getSide() == null) {
            String side = caller instanceof Provider ? "service" : "referer";
            this.setSide(side);
        }
        StringBuilder builder = new StringBuilder(128);
        this.append(builder, this.side);
        this.append(builder, caller.getUrl().getParameter(URLParamType.application.getName()));
        this.append(builder, caller.getUrl().getParameter(URLParamType.module.getName()));
        this.append(builder, NetUtils.getLocalAddress().getHostAddress());
        this.append(builder, request.getInterfaceName());
        this.append(builder, request.getMethodName());
        this.append(builder, request.getParamtersDesc());
        if ("referer".equals(this.side)) {
            this.append(builder, caller.getUrl().getHost());
            this.append(builder, caller.getUrl().getParameter(URLParamType.application.getName()));
            this.append(builder, caller.getUrl().getParameter(URLParamType.module.getName()));
        } else {
            this.append(builder, request.getAttachments().get(URLParamType.host.getName()));
            this.append(builder, request.getAttachments().get(URLParamType.application.getName()));
            this.append(builder, request.getAttachments().get(URLParamType.module.getName()));
        }
        this.append(builder, success);
        String requestId = request.getAttachments().get(URLParamType.requestIdFromClient.getName());
        if (StringUtils.isBlank((CharSequence)requestId)) {
            requestId = String.valueOf(request.getRequestId());
        }
        this.append(builder, requestId);
        this.append(builder, consumeTime);
        LoggerUtil.accessLog(builder.substring(0, builder.length() - 1));
    }

    private void append(StringBuilder builder, Object field) {
        if (field != null) {
            builder.append(StringTools.urlEncode(field.toString()));
        }
        builder.append("|");
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    static {
        MotanSwitcherUtil.initSwitcher(ACCESS_LOG_SWITCHER_NAME, false);
    }
}

