/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProviderProtectedMessageRouter
extends ProviderMessageRouter {
    protected ConcurrentMap<String, AtomicInteger> requestCounters = new ConcurrentHashMap<String, AtomicInteger>();
    protected AtomicInteger totalCounter = new AtomicInteger(0);

    public ProviderProtectedMessageRouter() {
    }

    public ProviderProtectedMessageRouter(Provider<?> provider) {
        super(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response call(Request request, Provider<?> provider) {
        int maxThread = provider.getUrl().getIntParameter(URLParamType.maxWorkerThread.getName(), URLParamType.maxWorkerThread.getIntValue());
        String requestKey = MotanFrameworkUtil.getFullMethodString(request);
        try {
            int requestCounter = 0;
            int totalCounter = 0;
            requestCounter = this.incrRequestCounter(requestKey);
            totalCounter = this.incrTotalCounter();
            if (this.isAllowRequest(requestCounter, totalCounter, maxThread, request)) {
                Response response = super.call(request, provider);
                return response;
            }
            Response response = this.reject(request.getInterfaceName() + "." + request.getMethodName(), requestCounter, totalCounter, maxThread);
            return response;
        }
        finally {
            this.decrTotalCounter();
            this.decrRequestCounter(requestKey);
        }
    }

    private Response reject(String method, int requestCounter, int totalCounter, int maxThread) {
        DefaultResponse response = new DefaultResponse();
        MotanServiceException exception = new MotanServiceException("ThreadProtectedRequestRouter reject request: request_counter=" + requestCounter + " total_counter=" + totalCounter + " max_thread=" + maxThread, MotanErrorMsgConstant.SERVICE_REJECT);
        exception.setStackTrace(new StackTraceElement[0]);
        response.setException(exception);
        LoggerUtil.error("ThreadProtectedRequestRouter reject request: request_method=" + method + " request_counter=" + requestCounter + " =" + totalCounter + " max_thread=" + maxThread);
        return response;
    }

    private int incrRequestCounter(String requestKey) {
        AtomicInteger counter = (AtomicInteger)this.requestCounters.get(requestKey);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.requestCounters.putIfAbsent(requestKey, counter);
            counter = (AtomicInteger)this.requestCounters.get(requestKey);
        }
        return counter.incrementAndGet();
    }

    private int decrRequestCounter(String requestKey) {
        AtomicInteger counter = (AtomicInteger)this.requestCounters.get(requestKey);
        if (counter == null) {
            return 0;
        }
        return counter.decrementAndGet();
    }

    private int incrTotalCounter() {
        return this.totalCounter.incrementAndGet();
    }

    private int decrTotalCounter() {
        return this.totalCounter.decrementAndGet();
    }

    protected boolean isAllowRequest(int requestCounter, int totalCounter, int maxThread, Request request) {
        if (this.methodCounter.get() == 1) {
            return true;
        }
        if (requestCounter == 1) {
            return true;
        }
        if (requestCounter > maxThread / 2 && totalCounter > maxThread * 3 / 4) {
            return false;
        }
        return this.methodCounter.get() < 4 || totalCounter <= maxThread * 3 / 4 || requestCounter <= maxThread * 1 / 4;
    }
}

