/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.ActiveWeightLoadBalance;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

@SpiMeta(name="configurableWeight")
public class ConfigurableWeightLoadBalance<T>
extends ActiveWeightLoadBalance<T> {
    private static final RefererListCacheHolder emptyHolder = new EmptyHolder();
    private volatile RefererListCacheHolder<T> holder = emptyHolder;
    private String weightString;

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        super.onRefresh(referers);
        this.holder = CollectionUtil.isEmpty(referers) ? emptyHolder : (StringUtils.isEmpty((CharSequence)this.weightString) ? new SingleGroupHolder<T>(referers) : new MultiGroupHolder<T>(this.weightString, referers));
    }

    @Override
    protected Referer<T> doSelect(Request request) {
        if (this.holder == emptyHolder) {
            return null;
        }
        RefererListCacheHolder<T> h = this.holder;
        Referer<T> r = h.next();
        if (!r.isAvailable()) {
            int retryTimes = this.getReferers().size() - 1;
            for (int i = 0; i < retryTimes && !(r = h.next()).isAvailable(); ++i) {
            }
        }
        if (r.isAvailable()) {
            return r;
        }
        this.noAvailableReferer();
        return null;
    }

    @Override
    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        if (this.holder == emptyHolder) {
            return;
        }
        RefererListCacheHolder<T> h = this.holder;
        int i = 0;
        int j = 0;
        while (i++ < this.getReferers().size()) {
            Referer<T> r = h.next();
            if (!r.isAvailable()) continue;
            refersHolder.add(r);
            if (++j != 10) continue;
            return;
        }
        if (refersHolder.isEmpty()) {
            this.noAvailableReferer();
        }
    }

    private void noAvailableReferer() {
        LoggerUtil.error(this.getClass().getSimpleName() + " \u5f53\u524d\u6ca1\u6709\u53ef\u7528\u8fde\u63a5, pool.size=" + this.getReferers().size());
    }

    @Override
    public void setWeightString(String weightString) {
        this.weightString = weightString;
    }

    class MultiGroupHolder<T>
    extends RefererListCacheHolder<T> {
        private int randomKeySize = 0;
        private List<String> randomKeyList = new ArrayList<String>();
        private Map<String, AtomicInteger> cursors = new HashMap<String, AtomicInteger>();
        private Map<String, List<Referer<T>>> groupReferers = new HashMap<String, List<Referer<T>>>();

        /*
         * WARNING - void declaration
         */
        MultiGroupHolder(String weights, List<Referer<T>> list) {
            void var10_14;
            LoggerUtil.info("ConfigurableWeightLoadBalance build new MultiGroupHolder. weights:" + weights);
            String[] groupsAndWeights = weights.split(",");
            int[] weightsArr = new int[groupsAndWeights.length];
            HashMap<String, Integer> weightsMap = new HashMap<String, Integer>(groupsAndWeights.length);
            int i = 0;
            String[] arr$ = groupsAndWeights;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_14 < len$) {
                String groupAndWeight = arr$[var10_14];
                String[] gw = groupAndWeight.split(":");
                if (gw.length == 2) {
                    Integer w = Integer.valueOf(gw[1]);
                    weightsMap.put(gw[0], w);
                    this.groupReferers.put(gw[0], new ArrayList());
                    weightsArr[i++] = w;
                }
                ++var10_14;
            }
            int weightGcd = this.findGcd(weightsArr);
            if (weightGcd != 1) {
                for (Map.Entry entry : weightsMap.entrySet()) {
                    weightsMap.put((String)entry.getKey(), (Integer)entry.getValue() / weightGcd);
                }
            }
            for (Map.Entry entry : weightsMap.entrySet()) {
                for (int j = 0; j < (Integer)entry.getValue(); ++j) {
                    this.randomKeyList.add((String)entry.getKey());
                }
            }
            Collections.shuffle(this.randomKeyList);
            this.randomKeySize = this.randomKeyList.size();
            for (String string : weightsMap.keySet()) {
                this.cursors.put(string, new AtomicInteger(0));
            }
            for (Referer referer : list) {
                this.groupReferers.get(referer.getServiceUrl().getGroup()).add(referer);
            }
        }

        @Override
        Referer<T> next() {
            String group = this.randomKeyList.get(ThreadLocalRandom.current().nextInt(this.randomKeySize));
            AtomicInteger ai = this.cursors.get(group);
            List<Referer<T>> referers = this.groupReferers.get(group);
            return referers.get(MathUtil.getPositive(ai.getAndIncrement()) % referers.size());
        }

        private int findGcd(int n, int m) {
            return n == 0 || m == 0 ? n + m : this.findGcd(m, n % m);
        }

        private int findGcd(int[] arr) {
            int i;
            for (i = 0; i < arr.length - 1; ++i) {
                arr[i + 1] = this.findGcd(arr[i], arr[i + 1]);
            }
            return this.findGcd(arr[i], arr[i - 1]);
        }
    }

    class SingleGroupHolder<T>
    extends RefererListCacheHolder<T> {
        private int size;
        private List<Referer<T>> cache;

        SingleGroupHolder(List<Referer<T>> list) {
            this.cache = list;
            this.size = list.size();
            LoggerUtil.info("ConfigurableWeightLoadBalance build new SingleGroupHolder.");
        }

        @Override
        Referer<T> next() {
            return this.cache.get(ThreadLocalRandom.current().nextInt(this.size));
        }
    }

    static class EmptyHolder<T>
    extends RefererListCacheHolder<T> {
        EmptyHolder() {
        }

        @Override
        Referer<T> next() {
            return null;
        }
    }

    static abstract class RefererListCacheHolder<T> {
        RefererListCacheHolder() {
        }

        abstract Referer<T> next();
    }
}

