/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import org.apache.commons.lang3.StringUtils;

public class MotanFrameworkUtil {
    public static String getServiceKey(Request request) {
        String version = MotanFrameworkUtil.getVersionFromRequest(request);
        String group = MotanFrameworkUtil.getGroupFromRequest(request);
        return MotanFrameworkUtil.getServiceKey(group, request.getInterfaceName(), version);
    }

    public static String getGroupFromRequest(Request request) {
        return MotanFrameworkUtil.getValueFromRequest(request, URLParamType.group.name(), URLParamType.group.getValue());
    }

    public static String getVersionFromRequest(Request request) {
        return MotanFrameworkUtil.getValueFromRequest(request, URLParamType.version.name(), URLParamType.version.getValue());
    }

    public static String getValueFromRequest(Request request, String key, String defaultValue) {
        String value = defaultValue;
        if (request.getAttachments() != null && request.getAttachments().containsKey(key)) {
            value = request.getAttachments().get(key);
        }
        return value;
    }

    public static String getServiceKey(URL url) {
        return MotanFrameworkUtil.getServiceKey(url.getGroup(), url.getPath(), url.getVersion());
    }

    public static String getProtocolKey(URL url) {
        return url.getProtocol() + "://" + url.getServerPortStr() + "/" + url.getGroup() + "/" + url.getPath() + "/" + url.getVersion();
    }

    public static String toString(Request request) {
        return "requestId=" + request.getRequestId() + " interface=" + request.getInterfaceName() + " method=" + request.getMethodName() + "(" + request.getParamtersDesc() + ")";
    }

    public static String getFullMethodString(Request request) {
        return MotanFrameworkUtil.getGroupFromRequest(request) + "_" + request.getInterfaceName() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")";
    }

    public static boolean checkIfCanShallServiceChannel(URL source, URL target) {
        if (!StringUtils.equals((CharSequence)source.getProtocol(), (CharSequence)target.getProtocol())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.codec.getName()), (CharSequence)target.getParameter(URLParamType.codec.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.serialize.getName()), (CharSequence)target.getParameter(URLParamType.serialize.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxContentLength.getName()), (CharSequence)target.getParameter(URLParamType.maxContentLength.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxServerConnection.getName()), (CharSequence)target.getParameter(URLParamType.maxServerConnection.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxWorkerThread.getName()), (CharSequence)target.getParameter(URLParamType.maxWorkerThread.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.workerQueueSize.getName()), (CharSequence)target.getParameter(URLParamType.workerQueueSize.getName()))) {
            return false;
        }
        return StringUtils.equals((CharSequence)source.getParameter(URLParamType.heartbeatFactory.getName()), (CharSequence)target.getParameter(URLParamType.heartbeatFactory.getName()));
    }

    public static boolean checkIfCanShallClientChannel(URL source, URL target) {
        if (!StringUtils.equals((CharSequence)source.getProtocol(), (CharSequence)target.getProtocol())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.codec.getName()), (CharSequence)target.getParameter(URLParamType.codec.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.serialize.getName()), (CharSequence)target.getParameter(URLParamType.serialize.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxContentLength.getName()), (CharSequence)target.getParameter(URLParamType.maxContentLength.getName()))) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getParameter(URLParamType.maxClientConnection.getName()), (CharSequence)target.getParameter(URLParamType.maxClientConnection.getName()))) {
            return false;
        }
        return StringUtils.equals((CharSequence)source.getParameter(URLParamType.heartbeatFactory.getName()), (CharSequence)target.getParameter(URLParamType.heartbeatFactory.getName()));
    }

    private static String getServiceKey(String group, String interfaceName, String version) {
        return group + "/" + interfaceName + "/" + version;
    }

    public static ProtocolConfig getDefaultProtocolConfig() {
        ProtocolConfig pc = new ProtocolConfig();
        pc.setId("motan");
        pc.setName("motan");
        return pc;
    }

    public static RegistryConfig getDefaultRegistryConfig() {
        RegistryConfig local = new RegistryConfig();
        local.setRegProtocol("local");
        return local;
    }
}

