/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.util.MathUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigUtil {
    public static Map<String, Integer> parseExport(String export) {
        String[] protocolAndPorts;
        if (StringUtils.isBlank((CharSequence)export)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> pps = new HashMap<String, Integer>();
        for (String pp : protocolAndPorts = MotanConstants.COMMA_SPLIT_PATTERN.split(export)) {
            if (StringUtils.isBlank((CharSequence)pp)) continue;
            String[] ppDetail = pp.split(":");
            if (ppDetail.length == 2) {
                pps.put(ppDetail[0], Integer.parseInt(ppDetail[1]));
                continue;
            }
            if (ppDetail.length == 1) {
                if ("injvm".equals(ppDetail[0])) {
                    pps.put(ppDetail[0], 0);
                    continue;
                }
                int port = MathUtil.parseInt(ppDetail[0], 0);
                if (port > 0) continue;
                throw new MotanServiceException("Export is malformed :" + export);
            }
            throw new MotanServiceException("Export is malformed :" + export);
        }
        return pps;
    }

    public static String extractProtocols(String export) {
        Map<String, Integer> protocols = ConfigUtil.parseExport(export);
        StringBuilder sb = new StringBuilder(16);
        for (String p : protocols.keySet()) {
            sb.append(p).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

