/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.codec;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.ReflectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

@SpiMeta(name="protobuf")
public class ProtobufCodec
implements Codec {
    private static final short MAGIC = -3856;
    private static final byte MASK = 7;

    public byte[] encode(Channel channel, Object message) throws IOException {
        try {
            if (message instanceof Request) {
                return this.encodeRequest(channel, (Request)message);
            }
            if (message instanceof Response) {
                return this.encodeResponse(channel, (Response)message);
            }
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException((Exception)e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("encode error: isResponse=" + (message instanceof Response), (Throwable)e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
        throw new MotanFrameworkException("encode error: message type not support, " + message.getClass(), MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
    }

    private byte[] encodeRequest(Channel channel, Request request) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CodedOutputStream output = CodedOutputStream.newInstance((OutputStream)outputStream);
        output.writeStringNoTag(request.getInterfaceName());
        output.writeStringNoTag(request.getMethodName());
        output.writeStringNoTag(request.getParamtersDesc());
        Serialization serialization = (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        if (request.getArguments() != null && request.getArguments().length > 0) {
            for (Object obj : request.getArguments()) {
                output.writeByteArrayNoTag(serialization.serialize(obj));
            }
        }
        if (request.getAttachments() == null || request.getAttachments().isEmpty()) {
            output.writeUInt32NoTag(0);
        } else {
            output.writeUInt32NoTag(request.getAttachments().size());
            for (Map.Entry entry : request.getAttachments().entrySet()) {
                output.writeStringNoTag((String)entry.getKey());
                output.writeStringNoTag((String)entry.getValue());
            }
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        byte flag = 0;
        return this.encode(body, flag, request.getRequestId());
    }

    private byte[] encodeResponse(Channel channel, Response value) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CodedOutputStream output = CodedOutputStream.newInstance((OutputStream)outputStream);
        Serialization serialization = (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        byte flag = 0;
        output.writeUInt64NoTag(value.getProcessTime());
        if (value.getException() != null) {
            output.writeStringNoTag(value.getException().getClass().getName());
            output.writeByteArrayNoTag(serialization.serialize((Object)value.getException()));
            flag = 5;
        } else if (value.getValue() == null) {
            flag = 3;
        } else {
            output.writeStringNoTag(value.getValue().getClass().getName());
            output.writeByteArrayNoTag(serialization.serialize(value.getValue()));
            flag = 1;
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        return this.encode(body, flag, value.getRequestId());
    }

    public Object decode(Channel channel, String remoteIp, byte[] data) throws IOException {
        if (data.length <= RpcProtocolVersion.VERSION_1.getHeaderLength()) {
            throw new MotanFrameworkException("decode error: format problem", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        short type = ByteUtil.bytes2short((byte[])data, (int)0);
        if (type != -3856) {
            throw new MotanFrameworkException("decode error: magic error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        if (data[2] != RpcProtocolVersion.VERSION_1.getVersion()) {
            throw new MotanFrameworkException("decode error: version error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        int bodyLength = ByteUtil.bytes2int((byte[])data, (int)12);
        if (RpcProtocolVersion.VERSION_1.getHeaderLength() + bodyLength != data.length) {
            throw new MotanFrameworkException("decode error: content length error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        byte flag = data[3];
        byte dataType = (byte)(flag & 7);
        boolean isResponse = dataType != 0;
        CodedInputStream body = CodedInputStream.newInstance((byte[])data, (int)RpcProtocolVersion.VERSION_1.getHeaderLength(), (int)bodyLength);
        long requestId = ByteUtil.bytes2long((byte[])data, (int)4);
        Serialization serialization = (Serialization)ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        try {
            if (isResponse) {
                return this.decodeResponse(body, dataType, requestId, serialization);
            }
            return this.decodeRequest(body, requestId, serialization);
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("decode " + (isResponse ? "response" : "request") + " error: class not found", (Throwable)e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException((Exception)e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("decode error: isResponse=" + isResponse, (Throwable)e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
    }

    private Object decodeRequest(CodedInputStream input, long requestId, Serialization serialization) throws IOException, ClassNotFoundException {
        String interfaceName = input.readString();
        String methodName = input.readString();
        String paramtersDesc = input.readString();
        DefaultRequest rpcRequest = new DefaultRequest();
        rpcRequest.setRequestId(requestId);
        rpcRequest.setInterfaceName(interfaceName);
        rpcRequest.setMethodName(methodName);
        rpcRequest.setParamtersDesc(paramtersDesc);
        rpcRequest.setArguments(this.decodeRequestParameter(input, paramtersDesc, serialization));
        rpcRequest.setAttachments(this.decodeRequestAttachments(input));
        return rpcRequest;
    }

    private Object[] decodeRequestParameter(CodedInputStream input, String parameterDesc, Serialization serialization) throws IOException, ClassNotFoundException {
        if (parameterDesc == null || parameterDesc.equals("")) {
            return null;
        }
        Class[] classTypes = ReflectUtil.forNames((String)parameterDesc);
        Object[] paramObjs = new Object[classTypes.length];
        for (int i = 0; i < classTypes.length; ++i) {
            paramObjs[i] = serialization.deserialize(input.readByteArray(), classTypes[i]);
        }
        return paramObjs;
    }

    private Map<String, String> decodeRequestAttachments(CodedInputStream input) throws IOException, ClassNotFoundException {
        int size = input.readUInt32();
        if (size <= 0) {
            return null;
        }
        HashMap<String, String> attachments = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            attachments.put(input.readString(), input.readString());
        }
        return attachments;
    }

    private Object decodeResponse(CodedInputStream input, byte dataType, long requestId, Serialization serialization) throws IOException, ClassNotFoundException {
        long processTime = input.readInt64();
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setProcessTime(processTime);
        if (dataType == 3) {
            return response;
        }
        String className = input.readString();
        Class clz = ReflectUtil.forName((String)className);
        Object result = serialization.deserialize(input.readByteArray(), clz);
        if (dataType == 1) {
            response.setValue(result);
        } else if (dataType == 5) {
            response.setException((Exception)result);
        } else {
            throw new MotanFrameworkException("decode error: response dataType not support " + dataType, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        response.setRequestId(requestId);
        return response;
    }

    private byte[] encode(byte[] body, byte flag, long requestId) throws IOException {
        byte[] header = new byte[RpcProtocolVersion.VERSION_1.getHeaderLength()];
        int offset = 0;
        ByteUtil.short2bytes((short)-3856, (byte[])header, (int)offset);
        offset += 2;
        header[offset++] = RpcProtocolVersion.VERSION_1.getVersion();
        header[offset++] = flag;
        ByteUtil.long2bytes((long)requestId, (byte[])header, (int)offset);
        ByteUtil.int2bytes((int)body.length, (byte[])header, (int)(offset += 8));
        byte[] data = new byte[header.length + body.length];
        System.arraycopy(header, 0, data, 0, header.length);
        System.arraycopy(body, 0, data, header.length, body.length);
        return data;
    }
}

