/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.weedow.schemaorg.commons.model.JsonLdNode;
import com.weedow.schemaorg.commons.model.JsonLdNodeImpl;
import com.weedow.schemaorg.serializer.JsonLdDataTypeModule;
import com.weedow.schemaorg.serializer.JsonLdException;
import com.weedow.schemaorg.serializer.JsonLdNodeMixIn;
import com.weedow.schemaorg.serializer.serialization.JsonLdSerializer;
import com.weedow.schemaorg.serializer.serialization.JsonLdSerializerOptions;
import java.util.List;
import java.util.Optional;

public class JsonLdSerializerImpl
implements JsonLdSerializer {
    private final ObjectMapper objectMapper;

    public JsonLdSerializerImpl() {
        this(JsonLdSerializerOptions.builder().build());
    }

    public JsonLdSerializerImpl(JsonLdSerializerOptions options) {
        this.objectMapper = JsonLdSerializerImpl.objectMapper(options);
    }

    private static ObjectMapper objectMapper(JsonLdSerializerOptions options) {
        JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).addMixIn(JsonLdNodeImpl.class, JsonLdNodeMixIn.class)).serializationInclusion(JsonInclude.Include.NON_NULL)).enable(new SerializationFeature[]{SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        builder.addModule((Module)new JsonLdDataTypeModule());
        if (!options.getModules().isEmpty()) {
            builder.addModules(options.getModules());
        }
        if (options.isPrettyPrint()) {
            builder.enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT});
        }
        return builder.build();
    }

    @Override
    public String serialize(JsonLdNode object) throws JsonLdException {
        try {
            JsonLdSerializerImpl.fixContext(object);
            return this.objectMapper.writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            throw new JsonLdException(String.format("JSON-LD serialization internal error for type %s.", JsonLdSerializerImpl.getTypeName(object)), e);
        }
    }

    @Override
    public String serialize(List<? extends JsonLdNode> objects) throws JsonLdException {
        try {
            Optional.ofNullable(objects).ifPresent(things -> things.forEach(JsonLdSerializerImpl::fixContext));
            return this.objectMapper.writeValueAsString(objects);
        }
        catch (JsonProcessingException e) {
            throw new JsonLdException(String.format("JSON-LD serialization internal error for type %s.", JsonLdSerializerImpl.getTypeName(objects)), e);
        }
    }

    private static void fixContext(JsonLdNode object) {
        if (object != null) {
            String context = object.getContext();
            object.setContext(context != null ? context : "https://schema.org");
        }
    }

    private static String getTypeName(JsonLdNode object) {
        return object != null ? object.getType() : null;
    }

    private static String getTypeName(List<? extends JsonLdNode> objects) {
        if (objects != null && !objects.isEmpty()) {
            return objects.iterator().next().getType();
        }
        return null;
    }
}

