/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.deserialization;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JsonLdCollectionDeserializer
extends StdDeserializer<List<?>> {
    private final DeserializationConfig config;
    private final JavaType contentType;
    private final transient JsonDeserializer<?> deserializer;
    private final transient JsonDeserializer<?> singleValueDeserializer;

    public JsonLdCollectionDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer, JsonDeserializer<?> singleValueDeserializer) {
        super(List.class);
        this.config = config;
        this.contentType = beanDesc.getType().getContentType();
        this.deserializer = deserializer;
        this.singleValueDeserializer = singleValueDeserializer;
    }

    public List<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return (List)this.deserializer.deserialize(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this.deserializeWithType(p);
        }
        if (this.singleValueDeserializer != null) {
            ClassNameIdResolver typeIdResolver = ClassNameIdResolver.construct((JavaType)this.contentType, (MapperConfig)this.config, (PolymorphicTypeValidator)this.config.getPolymorphicTypeValidator());
            AsPropertyTypeDeserializer asPropertyTypeDeserializer = new AsPropertyTypeDeserializer(this.contentType, (TypeIdResolver)typeIdResolver, typeDeserializer.getPropertyName(), false, ctxt.constructType(typeDeserializer.getDefaultImpl()), JsonTypeInfo.As.PROPERTY, true);
            return Arrays.asList(this.singleValueDeserializer.deserializeWithType(p, ctxt, (TypeDeserializer)asPropertyTypeDeserializer));
        }
        return this.deserializeWithType(p);
    }

    private List<Object> deserializeWithType(JsonParser p) throws IOException {
        Class rawClass = this.contentType.getRawClass();
        ObjectCodec objectCodec = p.getCodec();
        JsonNode listOrObjectNode = (JsonNode)objectCodec.readTree(p);
        ArrayList<Object> result = new ArrayList<Object>();
        if (listOrObjectNode.isArray()) {
            for (JsonNode node : listOrObjectNode) {
                result.add(objectCodec.treeToValue((TreeNode)node, rawClass));
            }
        } else {
            result.add(objectCodec.treeToValue((TreeNode)listOrObjectNode, rawClass));
        }
        return result;
    }
}

