/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.converter;

import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.serializer.converter.ConversionService;
import com.weedow.schemaorg.serializer.converter.Converter;
import com.weedow.schemaorg.serializer.spec.DataTypeSpecificationService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionServiceImpl
implements ConversionService {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionServiceImpl.class);
    private final List<Converter<Object, ? extends JsonLdDataType<?>>> converters = DataTypeSpecificationService.getInstance().getConverters();
    private final Map<ConverterCacheKey, Converter<Object, ? extends JsonLdDataType<?>>> converterCache = new ConcurrentHashMap();

    @Override
    public <T extends JsonLdDataType<?>> T convert(Object source, Class<T> targetType) {
        Converter<Object, T> converter = this.getConverter(source != null ? source.getClass() : null, targetType);
        return (T)(converter != null ? (JsonLdDataType)converter.convert(source, targetType) : null);
    }

    private <T extends JsonLdDataType<?>> Converter<Object, T> getConverter(Class<?> sourceType, Class<T> targetType) {
        ConverterCacheKey key = new ConverterCacheKey(sourceType, targetType);
        return this.converterCache.computeIfAbsent(key, t -> this.getJsonLdDataTypeConverter(sourceType, targetType));
    }

    private <T extends JsonLdDataType<?>> Converter<Object, ? extends JsonLdDataType<?>> getJsonLdDataTypeConverter(Class<?> sourceType, Class<T> targetType) {
        for (Converter<Object, JsonLdDataType<?>> converter : this.converters) {
            if (!converter.supports(targetType, sourceType)) continue;
            return converter;
        }
        LOG.warn("Could not found a converter for type {}", targetType);
        return null;
    }

    private record ConverterCacheKey(Class<?> sourceType, Class<?> targetType) implements Comparable<ConverterCacheKey>
    {
        @Override
        public int compareTo(ConverterCacheKey other) {
            int result = this.sourceType.toString().compareTo(other.sourceType.toString());
            if (result == 0) {
                result = this.targetType.toString().compareTo(other.targetType.toString());
            }
            return result;
        }
    }
}

