package com.webkul.mobikul.mobikuldialoglibrary;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.webkul.mobikul.mobikuldialoglibrary.databinding.DialogProgressColoredBinding;

/**
 * Created by anchit.makkar on 18/11/17.
 */

@SuppressWarnings("WeakerAccess")
public class ColoredSimpleProgressDialog extends Dialog {
    private final DialogProgressColoredBinding binding;
    private Context mContext;
    @ColorRes
    private int mBackGroundColorResource, mProgressBarColorResource;
    private Drawable mBackGroundDrawable, mProgressBarDrawable, mSeparatorDrawable;
    private String mTextViewText, mTitleText;
    private int mTextViewTextSize, mTitleTextSize;
    private int TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_PX;
    private int TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_PX;
    private Drawable mTextBackgroundDrawable;
    private boolean mShowTitle = true;
    private boolean mShowTitleSeparator = true;

    public ColoredSimpleProgressDialog(@NonNull Context context) {
        this(context, false, null);
    }

    public ColoredSimpleProgressDialog(@NonNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        mContext = context;
        binding = DialogProgressColoredBinding.inflate(LayoutInflater.from(context), null, false);
        this.setContentView(binding.getRoot());
    }

    public ColoredSimpleProgressDialog setBackGroundColor(@ColorRes int color) {
        mBackGroundColorResource = color;
        return this;
    }

    public ColoredSimpleProgressDialog setBackGroundColor(Color color) {
        mBackGroundDrawable = new ColorDrawable(Color.parseColor(color.toString()));
        return this;
    }

    public ColoredSimpleProgressDialog setBackGroundColor(String color) {
        mBackGroundDrawable = new ColorDrawable(Color.parseColor(color));
        return this;
    }

    public ColoredSimpleProgressDialog setBackGroundDrawable(@DrawableRes int drawableInt) {
        mBackGroundDrawable = ContextCompat.getDrawable(mContext, drawableInt);
        return this;
    }

    public ColoredSimpleProgressDialog setBackGroundDrawable(Drawable drawable) {
        mBackGroundDrawable = drawable;
        return this;
    }

    public ColoredSimpleProgressDialog setProgressBarColor(@ColorRes int color) {
        mProgressBarColorResource = color;
        return this;
    }

    public ColoredSimpleProgressDialog setProgressBarColor(Color color) {
        mProgressBarDrawable = new ColorDrawable(Color.parseColor(color.toString()));
        return this;
    }

    public ColoredSimpleProgressDialog setProgressBarColor(String color) {
        mProgressBarDrawable = new ColorDrawable(Color.parseColor(color));
        return this;
    }

    public ColoredSimpleProgressDialog setProgressBarDrawable(Drawable drawable) {
        mProgressBarDrawable = drawable;
        return this;
    }

    public ColoredSimpleProgressDialog setText(String text) {
        mTextViewText = text;
        return this;
    }

    public ColoredSimpleProgressDialog setText(@StringRes int text) {
        mTextViewText = mContext.getString(text);
        return this;
    }

    public ColoredSimpleProgressDialog setTitleText(String text) {
        mTitleText = text;
        return this;
    }

    public ColoredSimpleProgressDialog setTitleText(@StringRes int text) {
        mTitleText = mContext.getString(text);
        return this;
    }


    public ColoredSimpleProgressDialog setContentTextSize(int size) {
        mTextViewTextSize = size;
        return this;
    }

    public ColoredSimpleProgressDialog setContentTextSizeInSP(int size) {
        TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_SP;
        mTextViewTextSize = size;
        return this;
    }

    public void setContentTextSizeResource(@DimenRes int size) {
        mTextViewTextSize = mContext.getResources().getDimensionPixelSize(size);
    }

    public ColoredSimpleProgressDialog setTitleTextSize(int size) {
        mTitleTextSize = size;
        return this;
    }

    public ColoredSimpleProgressDialog setTitleTextSizeWithUnit(int size, int unit) {
        switch (unit) {
            case TypedValue.COMPLEX_UNIT_DIP:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_DIP;
                break;
            case TypedValue.COMPLEX_UNIT_SP:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_SP;
                break;
            case TypedValue.COMPLEX_UNIT_PT:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_PT;
                break;
            case TypedValue.COMPLEX_UNIT_IN:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_IN;
                break;
            case TypedValue.COMPLEX_UNIT_MM:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_MM;
                break;
            case TypedValue.COMPLEX_UNIT_PX:
            default:
                TITLE_TEXT_VIEW_SCALE_TYPE = TypedValue.COMPLEX_UNIT_PX;
                break;
        }

        mTitleTextSize = size;

        return this;
    }

    public void setTitleTextSizeResource(@DimenRes int size) {
        mTitleTextSize = mContext.getResources().getDimensionPixelSize(size);
    }


    public ColoredSimpleProgressDialog setTextBackGroundColor(Color color) {
        mTextBackgroundDrawable = new ColorDrawable(Color.parseColor(color.toString()));
        return this;
    }

    public ColoredSimpleProgressDialog setTextBackGroundColor(String color) {
        mTextBackgroundDrawable = new ColorDrawable(Color.parseColor(color));
        return this;
    }

    public ColoredSimpleProgressDialog setTextBackGroundDrawable(@DrawableRes int drawableInt) {
        mTextBackgroundDrawable = ContextCompat.getDrawable(mContext, drawableInt);
        return this;
    }

    public ColoredSimpleProgressDialog setTextBackGroundDrawable(Drawable drawable) {
        mTextBackgroundDrawable = drawable;
        return this;
    }

    public ColoredSimpleProgressDialog showTitle(boolean show) {
        mShowTitle = show;
        return this;
    }

    public ColoredSimpleProgressDialog showTitleSeparator(boolean show) {
        mShowTitleSeparator = show;
        return this;
    }

    public ColoredSimpleProgressDialog setTitleAndContentSeparatorColor(Color color){
        mSeparatorDrawable = new ColorDrawable(Color.parseColor(color.toString()));
        return  this;
    }

    public ColoredSimpleProgressDialog setTitleAndContentSeparatorColor(String color){
        mSeparatorDrawable = new ColorDrawable(Color.parseColor(color));
        return  this;
    }

    public ColoredSimpleProgressDialog setTitleAndContentSeparatorColor(@ColorRes int color){

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            mSeparatorDrawable = new ColorDrawable(mContext.getColor(color));
        }else {
            mSeparatorDrawable = new ColorDrawable(mContext.getResources().getColor(color));
        }
        return  this;
    }

    public ProgressBar getProgressBar(){
        return binding.progressBar;
    }
    public TextView getContentView(){
        return binding.text;
    }
    public TextView getTitleView(){
        return binding.titleTextView;
    }
    public View getTitleSeparatorView(){
        return binding.titleAndContentSeparator;
    }

    public LinearLayout getTitleContainerview(){
        return binding.titleContainer;
    }

    public LinearLayout getContentContainerView(){
        return binding.contentContainer;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (mBackGroundColorResource != 0) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                binding.window.setBackgroundColor(mContext.getColor(mBackGroundColorResource));
            }else {
                binding.window.setBackgroundColor(mContext.getResources().getColor(mBackGroundColorResource));
            }
        }
        if (mBackGroundDrawable != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                binding.window.setBackground(mBackGroundDrawable);
            } else {
                binding.window.setBackgroundDrawable(mBackGroundDrawable);
            }
        }
        if (mTextViewText != null) {
            binding.text.setText(mTextViewText);
        }
        if (mTitleText != null) {
            binding.titleTextView.setText(mTitleText);
        }

        if (mShowTitle) {
            binding.titleContainer.setVisibility(View.VISIBLE);
        } else {
            binding.titleContainer.setVisibility(View.GONE);
        }

        if (mShowTitleSeparator) {
            binding.titleAndContentSeparator.setVisibility(View.VISIBLE);
        } else {
            binding.titleAndContentSeparator.setVisibility(View.GONE);
        }


        if (mTextViewTextSize != 0) {
            binding.text.setTextSize(TEXT_VIEW_SCALE_TYPE, mTextViewTextSize);
        }
        if (mTitleTextSize != 0){
            binding.titleTextView.setTextSize(TITLE_TEXT_VIEW_SCALE_TYPE,mTitleTextSize);
        }
        if (mTextBackgroundDrawable != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                binding.text.setBackground(mTextBackgroundDrawable);
            } else {
                binding.text.setBackgroundDrawable(mTextBackgroundDrawable);
            }
        }

        if (mSeparatorDrawable != null){
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                binding.titleAndContentSeparator.setBackground(mSeparatorDrawable);
            }else {
                binding.titleAndContentSeparator.setBackgroundDrawable(mSeparatorDrawable);
            }
        }



        boolean indeterminate = binding.progressBar.isIndeterminate();

        try {
            if (mProgressBarColorResource != 0) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    if (indeterminate) {
                        binding.progressBar.setIndeterminateTintList(ColorStateList.valueOf(mContext.getResources().getColor(mProgressBarColorResource, null)));
                    } else {
                        binding.progressBar.setProgressTintList(ColorStateList.valueOf(mContext.getResources().getColor(mProgressBarColorResource, null)));
                    }
                } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    if (indeterminate) {
                        binding.progressBar.setIndeterminateTintList(ColorStateList.valueOf(mContext.getResources().getColor(mProgressBarColorResource)));
                    } else {
                        binding.progressBar.setProgressTintList(ColorStateList.valueOf(mContext.getResources().getColor(mProgressBarColorResource)));
                    }
                } else {
                    if (indeterminate) {
                        binding.progressBar.getIndeterminateDrawable().setColorFilter(mContext.getResources().getColor(mProgressBarColorResource), PorterDuff.Mode.SRC_IN);
                    } else {
                        binding.progressBar.getProgressDrawable().setColorFilter(mContext.getResources().getColor(mProgressBarColorResource), PorterDuff.Mode.SRC_IN);
                    }
                }
            }
            if (mProgressBarDrawable != null) {
                if (mProgressBarDrawable instanceof ColorDrawable) {
                    if (indeterminate) {
                        binding.progressBar.getIndeterminateDrawable().setColorFilter(((ColorDrawable) mProgressBarDrawable).getColor(), PorterDuff.Mode.SRC_IN);
                    } else {
                        binding.progressBar.getProgressDrawable().setColorFilter(((ColorDrawable) mProgressBarDrawable).getColor(), PorterDuff.Mode.SRC_IN);
                    }

                } else {
                    if (indeterminate) {
                        binding.progressBar.setIndeterminateDrawable(mProgressBarDrawable);
                    } else {
                        binding.progressBar.setProgressDrawable(mProgressBarDrawable);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static ColoredSimpleProgressDialog getIntstantProgressDialog(Context context){
        ColoredSimpleProgressDialog coloredSimpleProgressDialog = new ColoredSimpleProgressDialog(context);
        coloredSimpleProgressDialog.showTitle(true);
        coloredSimpleProgressDialog.showTitleSeparator(true);
        coloredSimpleProgressDialog.setTitleText(R.string.progress_dialog_title_text);
        coloredSimpleProgressDialog.setText(R.string.progress_dialog_content_text);
        coloredSimpleProgressDialog.setCanceledOnTouchOutside(true);
        coloredSimpleProgressDialog.setCancelable(true);

        return coloredSimpleProgressDialog;
    }


}

