/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.ruby_json_client;

import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.JacksonModule;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.EnunciateJackson1Context;
import com.webcohesion.enunciate.modules.jackson1.Jackson1Module;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.modules.ruby_json_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.ruby_json_client.RubyJSONClientObjectWrapper;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import com.webcohesion.enunciate.util.freemarker.SimpleNameWithParamsMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class RubyJSONClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule {
    JacksonModule jacksonModule;
    Jackson1Module jackson1Module;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "ruby-json-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JacksonModule) {
                    RubyJSONClientModule.this.jacksonModule = (JacksonModule)module;
                    return true;
                }
                if (module instanceof Jackson1Module) {
                    RubyJSONClientModule.this.jackson1Module = (Jackson1Module)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    RubyJSONClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "optional jackson, optional jackson1, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        String pckg;
        if ((this.jacksonModule == null || this.jacksonModule.getJacksonContext() == null || this.jacksonModule.getJacksonContext().getTypeDefinitions().isEmpty()) && (this.jackson1Module == null || this.jackson1Module.getJacksonContext() == null || this.jackson1Module.getJacksonContext().getTypeDefinitions().isEmpty())) {
            this.info("No Jackson JSON data types: Ruby JSON client will not be generated.", new Object[0]);
            return;
        }
        if (this.usesUnmappableElements()) {
            this.warn("Web service API makes use of elements that cannot be handled by the Ruby JSON client. Ruby JSON client will not be generated.", new Object[0]);
            return;
        }
        Map<String, String> packageToModuleConversions = this.getPackageToModuleConversions();
        ArrayList<TypeDefinition> schemaTypes = new ArrayList<TypeDefinition>();
        ExtensionDepthComparator comparator = new ExtensionDepthComparator();
        EnunciateJacksonContext jacksonContext = null;
        EnunciateJackson1Context jackson1Context = null;
        if (this.jacksonModule != null) {
            jacksonContext = this.jacksonModule.getJacksonContext();
            for (TypeDefinition typeDefinition : jacksonContext.getTypeDefinitions()) {
                int position;
                pckg = typeDefinition.getPackage().getQualifiedName().toString();
                if (!packageToModuleConversions.containsKey(pckg)) {
                    packageToModuleConversions.put(pckg, this.packageToModule(pckg));
                }
                if ((position = Collections.binarySearch(schemaTypes, typeDefinition, comparator)) < 0) {
                    position = -position - 1;
                }
                schemaTypes.add(position, typeDefinition);
            }
        }
        if (this.jackson1Module != null) {
            jackson1Context = this.jackson1Module.getJacksonContext();
            for (TypeDefinition typeDefinition : jackson1Context.getTypeDefinitions()) {
                pckg = typeDefinition.getPackage().getQualifiedName().toString();
                if (!packageToModuleConversions.containsKey(pckg)) {
                    packageToModuleConversions.put(pckg, this.packageToModule(pckg));
                }
                schemaTypes.add(typeDefinition);
            }
        }
        File srcDir = this.getSourceDir();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("schemaTypes", schemaTypes);
        model.put("schemaTypes", schemaTypes);
        model.put("packages2modules", packageToModuleConversions);
        model.put("moduleFor", new ClientPackageForMethod(packageToModuleConversions, this.context));
        ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(packageToModuleConversions, jacksonContext, jackson1Context);
        model.put("classnameFor", (Object)classnameFor);
        SimpleNameWithParamsMethod simpleNameFor = new SimpleNameWithParamsMethod((com.webcohesion.enunciate.util.freemarker.ClientClassnameForMethod)classnameFor);
        model.put("simpleNameFor", simpleNameFor);
        model.put("rubyFileName", this.getSourceFileName());
        model.put("file", new FileDirective(srcDir));
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        if (!this.isUpToDateWithSources(srcDir)) {
            this.debug("Generating the Ruby JSON data classes...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            try {
                this.processTemplate(apiTemplate, model);
            }
            catch (IOException e) {
                throw new EnunciateException((Throwable)e);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
        } else {
            this.info("Skipping Ruby code generation because everything appears up-to-date.", new Object[0]);
        }
        ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "ruby.json.client.library", "Ruby JSON Client Library");
        artifactBundle.setPlatform("Ruby");
        FileArtifact sourceScript = new FileArtifact(this.getName(), "ruby.json.client", new File(srcDir, this.getSourceFileName()));
        sourceScript.setArtifactType(ArtifactType.binaries);
        sourceScript.setPublic(false);
        String description = this.readResource("library_description.fmt", model);
        artifactBundle.setDescription(description);
        artifactBundle.addArtifact(sourceScript);
        this.enunciate.addArtifact((Artifact)artifactBundle);
    }

    protected boolean usesUnmappableElements() {
        boolean usesUnmappableElements = false;
        if (this.jacksonModule != null && this.jacksonModule.getJacksonContext() != null) {
            for (TypeDefinition complexType : this.jacksonModule.getJacksonContext().getTypeDefinitions()) {
                if (Character.isUpperCase(complexType.getClientSimpleName().charAt(0))) continue;
                this.warn("%s: Ruby requires your class name to be upper-case. Please rename the class or apply the @org.codehaus.enunciate.ClientName annotation to the class.", new Object[]{this.positionOf((Element)complexType)});
                usesUnmappableElements = true;
            }
        }
        if (this.jackson1Module != null && this.jackson1Module.getJacksonContext() != null) {
            for (TypeDefinition complexType : this.jackson1Module.getJacksonContext().getTypeDefinitions()) {
                if (Character.isUpperCase(complexType.getClientSimpleName().charAt(0))) continue;
                this.warn("%s: Ruby requires your class name to be upper-case. Please rename the class or apply the @org.codehaus.enunciate.ClientName annotation to the class.", new Object[]{this.positionOf((Element)complexType)});
                usesUnmappableElements = true;
            }
        }
        return usesUnmappableElements;
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new RubyJSONClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected String packageToModule(String pckg) {
        if (pckg == null) {
            return null;
        }
        StringBuilder ns = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(pckg, ".");
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            ns.append(Character.toString(tok.charAt(0)).toUpperCase());
            if (tok.length() > 1) {
                ns.append(tok.substring(1));
            }
            if (!toks.hasMoreTokens()) continue;
            ns.append("::");
        }
        return ns.toString();
    }

    protected String readResource(String resource, Map<String, Object> model) {
        model.put("sample_resource", this.findExampleResourceMethod());
        URL res = RubyJSONClientModule.class.getResource(resource);
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups();
        for (ResourceGroup resourceGroup : resourceGroups) {
            List resources = resourceGroup.getResources();
            for (Resource resource : resources) {
                for (Method method : resource.getMethods()) {
                    if (!this.hasXmlResponseEntity(method)) continue;
                    if (this.hasXmlRequestEntity(method)) {
                        return method;
                    }
                    example = example == null ? method : example;
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                if (!"JSON".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                if (!"JSON".equals(mediaTypeDescriptor.getSyntax())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getSourceFileName() {
        return this.getSlug() + ".rb";
    }

    protected URL getTemplateURL(String template) {
        return RubyJSONClientModule.class.getResource(template);
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public Map<String, String> getPackageToModuleConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }

    private static final class ExtensionDepthComparator
    implements Comparator<DecoratedTypeElement> {
        private ExtensionDepthComparator() {
        }

        @Override
        public int compare(DecoratedTypeElement t1, DecoratedTypeElement t2) {
            int depth1 = 0;
            int depth2 = 0;
            DecoratedTypeMirror superType = (DecoratedTypeMirror)t1.getSuperclass();
            while (superType != null && superType.isDeclared() && !Object.class.getName().equals(((TypeElement)((DeclaredType)superType).asElement()).getQualifiedName().toString())) {
                ++depth1;
                superType = (DecoratedTypeMirror)((TypeElement)((DeclaredType)superType).asElement()).getSuperclass();
            }
            superType = (DecoratedTypeMirror)t2.getSuperclass();
            while (superType != null && superType.isDeclared() && !Object.class.getName().equals(((TypeElement)((DeclaredType)superType).asElement()).getQualifiedName().toString())) {
                ++depth2;
                superType = (DecoratedTypeMirror)((TypeElement)((DeclaredType)superType).asElement()).getSuperclass();
            }
            return depth1 - depth2;
        }
    }
}

