/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.java_json_client;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.DefaultRegistrationContext;
import com.webcohesion.enunciate.api.resources.MediaTypeDescriptor;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryJavaArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.facets.HasFacets;
import com.webcohesion.enunciate.javac.decorations.SourcePosition;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.ProjectExtensionModule;
import com.webcohesion.enunciate.modules.jackson.EnunciateJacksonContext;
import com.webcohesion.enunciate.modules.jackson.JacksonModule;
import com.webcohesion.enunciate.modules.jackson.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson.model.util.JacksonCodeErrors;
import com.webcohesion.enunciate.modules.java_json_client.ClientClassnameForMethod;
import com.webcohesion.enunciate.modules.java_json_client.JavaJSONClientObjectWrapper;
import com.webcohesion.enunciate.modules.java_json_client.JsonContext;
import com.webcohesion.enunciate.modules.java_json_client.MediaTypeForMethod;
import com.webcohesion.enunciate.modules.java_json_client.SimpleNameForMethod;
import com.webcohesion.enunciate.modules.jaxrs.JaxrsModule;
import com.webcohesion.enunciate.util.AntPatternMatcher;
import com.webcohesion.enunciate.util.freemarker.AnnotationValueMethod;
import com.webcohesion.enunciate.util.freemarker.ClientPackageForMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import com.webcohesion.enunciate.util.freemarker.IsFacetExcludedMethod;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.apache.commons.configuration2.HierarchicalConfiguration;

public class JavaJSONClientModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule,
ProjectExtensionModule {
    private static final String LIRBARY_DESCRIPTION_PROPERTY = "com.webcohesion.enunciate.modules.java_xml_client.EnunciateJavaJSONClientModule#LIRBARY_DESCRIPTION_PROPERTY";
    JacksonModule jacksonModule;
    JaxrsModule jaxrsModule;

    public String getName() {
        return "java-json-client";
    }

    public List<DependencySpec> getDependencySpecifications() {
        return List.of(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JacksonModule) {
                    JavaJSONClientModule.this.jacksonModule = (JacksonModule)module;
                    return true;
                }
                if (module instanceof JaxrsModule) {
                    JavaJSONClientModule.this.jaxrsModule = (JaxrsModule)module;
                    return true;
                }
                return module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "jackson, optional jaxrs";
            }
        });
    }

    public void call(EnunciateContext context) {
        if (this.jacksonModule == null || this.jacksonModule.getJacksonContext() == null || this.jacksonModule.getJacksonContext().getTypeDefinitions().isEmpty()) {
            this.info("No Jackson JSON data types: Java JSON client will not be generated.", new Object[0]);
            return;
        }
        this.detectAccessorNamingErrors();
        File sourceDir = this.generateClientSources();
        File compileDir = this.compileClientSources(sourceDir);
        this.packageArtifacts(sourceDir, compileDir);
    }

    protected void detectAccessorNamingErrors() {
        List namingConflicts = JacksonCodeErrors.findConflictingAccessorNamingErrors((EnunciateJacksonContext)this.jacksonModule.getJacksonContext());
        if (namingConflicts != null && !namingConflicts.isEmpty()) {
            this.error("Jackson naming conflicts have been found:", new Object[0]);
            for (String namingConflict : namingConflicts) {
                this.error(namingConflict, new Object[0]);
            }
            this.error("These naming conflicts are often between the field and it's associated property, in which case you need to use one or both of the following strategies to avoid the conflicts:", new Object[0]);
            this.error("1. Explicitly exclude one or the other.", new Object[0]);
            this.error("2. Put the annotations on the property instead of the field.", new Object[0]);
            throw new EnunciateException("Jackson naming conflicts detected.");
        }
    }

    protected File generateClientSources() {
        File sourceDir = this.getSourceDir();
        sourceDir.mkdirs();
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map<String, String> conversions = this.getClientPackageConversions();
        EnunciateJacksonContext jacksonContext = this.jacksonModule != null ? this.jacksonModule.getJacksonContext() : null;
        JsonContext jsonContext = new JsonContext(jacksonContext);
        model.put("packageFor", new ClientPackageForMethod(conversions, this.context));
        model.put("classnameFor", (Object)new ClientClassnameForMethod(conversions, jsonContext));
        model.put("simpleNameFor", (Object)new SimpleNameForMethod(new ClientClassnameForMethod(conversions, jsonContext, true), jsonContext));
        model.put("file", new FileDirective(sourceDir, this.enunciate.getLogger()));
        model.put("generatedCodeLicense", this.enunciate.getConfiguration().readGeneratedCodeLicenseFile());
        model.put("annotationValue", new AnnotationValueMethod());
        model.put("wrapRootValue", this.jacksonModule.isWrapRootValue());
        TreeSet<String> facetIncludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetIncludes());
        facetIncludes.addAll(this.getFacetIncludes());
        TreeSet<String> facetExcludes = new TreeSet<String>(this.enunciate.getConfiguration().getFacetExcludes());
        facetExcludes.addAll(this.getFacetExcludes());
        FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
        model.put("isFacetExcluded", new IsFacetExcludedMethod(facetFilter));
        AntPatternMatcher matcher = new AntPatternMatcher();
        matcher.setPathSeparator(".");
        boolean upToDate = this.isUpToDateWithSources(sourceDir);
        if (!upToDate) {
            try {
                this.debug("Generating the Java client classes...", new Object[0]);
                for (TypeDefinition typeDefinition : jacksonContext.getTypeDefinitions()) {
                    if (!facetFilter.accept((HasFacets)typeDefinition)) continue;
                    if (this.useServerSide((TypeElement)typeDefinition, matcher)) {
                        this.copyServerSideType(sourceDir, (TypeElement)typeDefinition);
                        continue;
                    }
                    model.put("type", typeDefinition);
                    URL template = typeDefinition.isEnum() ? this.getTemplateURL("client-enum-type.fmt") : (typeDefinition.isSimple() ? this.getTemplateURL("client-simple-type.fmt") : this.getTemplateURL("client-complex-type.fmt"));
                    this.processTemplate(template, model);
                }
            }
            catch (TemplateException | IOException e) {
                throw new EnunciateException(e);
            }
        } else {
            this.info("Skipping generation of Java client sources as everything appears up-to-date...", new Object[0]);
        }
        this.context.setProperty(LIRBARY_DESCRIPTION_PROPERTY, (Object)this.readLibraryDescription(model));
        return sourceDir;
    }

    protected void copyServerSideType(File sourceDir, TypeElement type) throws IOException {
        SourcePosition source = this.context.getProcessingEnvironment().findSourcePosition((Element)type);
        JavaFileObject sourceFile = source.getSourceFile();
        File destFile = this.getServerSideDestFile(sourceDir, sourceFile, type);
        FileWriter writer = new FileWriter(destFile);
        this.debug("Writing server-side java type to %s.", new Object[]{destFile});
        writer.write(sourceFile.getCharContent(false).toString());
        writer.flush();
        writer.close();
    }

    protected File getSourceDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "src");
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(FreemarkerUtil.VERSION);
        configuration.setLocale(new Locale("en", "US"));
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler((templateException, environment, writer) -> {
            throw templateException;
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new JavaJSONClientObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected File getServerSideDestFile(File sourceDir, JavaFileObject sourceFile, TypeElement declaration) {
        File destDir = sourceDir;
        String packageName = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(declaration).getQualifiedName().toString();
        StringTokenizer packagePaths = new StringTokenizer(packageName, ".");
        while (packagePaths.hasMoreTokens()) {
            String packagePath = packagePaths.nextToken();
            destDir = new File(destDir, packagePath);
        }
        destDir.mkdirs();
        String simpleFilename = sourceFile.toUri().toString();
        simpleFilename = simpleFilename.substring(simpleFilename.lastIndexOf(47));
        return new File(destDir, simpleFilename);
    }

    protected boolean useServerSide(TypeElement declaration, AntPatternMatcher matcher) {
        boolean useServerSide = false;
        for (String pattern : this.getServerSideTypesToUse()) {
            if (!matcher.match(pattern, declaration.getQualifiedName().toString())) continue;
            useServerSide = true;
            break;
        }
        return useServerSide;
    }

    protected File compileClientSources(File sourceDir) {
        File compileDir = this.getCompileDir();
        compileDir.mkdirs();
        if (!this.isDisableCompile()) {
            if (!this.isUpToDateWithSources(compileDir)) {
                List<File> sources = this.findJavaFiles(sourceDir);
                if (sources != null && !sources.isEmpty()) {
                    List<String> options;
                    String classpath = this.enunciate.writeClasspath(this.enunciate.getClasspath());
                    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                    JavaCompiler.CompilationTask task = compiler.getTask(null, null, null, options = Arrays.asList("-source", this.getJavacSource(), "-target", this.getJavacTarget(), "-encoding", "UTF-8", "-cp", classpath, "-d", compileDir.getAbsolutePath(), "-nowarn"), null, compiler.getStandardFileManager(null, null, null).getJavaFileObjectsFromFiles(sources));
                    if (!task.call().booleanValue()) {
                        throw new EnunciateException("Compile failed of Java JSON client-side classes.");
                    }
                } else {
                    this.debug("No Java JSON client classes to compile.", new Object[0]);
                }
            } else {
                this.info("Skipping compilation of Java JSON client classes as everything appears up-to-date...", new Object[0]);
            }
        }
        return compileDir;
    }

    private List<File> findJavaFiles(File sourceDir) {
        ArrayList<File> javaFiles = new ArrayList<File>();
        this.enunciate.visitFiles(sourceDir, Enunciate.JAVA_FILTER, javaFiles::add);
        return javaFiles;
    }

    protected File getCompileDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "classes");
    }

    protected File getResourcesDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "resources");
    }

    protected File packageArtifacts(File sourceDir, File compileDir) {
        File packageDir = this.getPackageDir();
        packageDir.mkdirs();
        try {
            String jarName = this.getJarName();
            File clientJarFile = null;
            if (!this.isDisableCompile()) {
                clientJarFile = new File(packageDir, jarName);
                if (!this.isUpToDateWithSources(clientJarFile)) {
                    if (this.isBundleSourcesWithClasses()) {
                        anyFiles = this.enunciate.jar(clientJarFile, this.getManifest(), new File[]{sourceDir, compileDir});
                        if (!anyFiles) {
                            clientJarFile = null;
                        }
                    } else {
                        anyFiles = this.enunciate.jar(clientJarFile, this.getManifest(), new File[]{compileDir});
                        if (!anyFiles) {
                            clientJarFile = null;
                        }
                    }
                } else {
                    this.info("Skipping creation of Java client jar as everything appears up-to-date...", new Object[0]);
                }
            }
            File clientSourcesJarFile = null;
            if (!this.isBundleSourcesWithClasses()) {
                clientSourcesJarFile = new File(packageDir, jarName.replaceFirst("\\.jar", "-json-sources.jar"));
                if (!this.isUpToDateWithSources(clientSourcesJarFile)) {
                    boolean anyFiles = this.enunciate.zip(clientSourcesJarFile, new File[]{sourceDir});
                    if (!anyFiles) {
                        clientSourcesJarFile = null;
                    }
                } else {
                    this.info("Skipping creation of the Java client source jar as everything appears up-to-date...", new Object[0]);
                }
            }
            ClientLibraryJavaArtifact artifactBundle = new ClientLibraryJavaArtifact(this.getName(), "java.json.client.library", "Java JSON Client Library");
            artifactBundle.setGroupId(this.getGroupId());
            artifactBundle.setArtifactId(this.getArtifactId());
            artifactBundle.setVersion(this.getVersion());
            artifactBundle.setPlatform("Java (Version 5+)");
            artifactBundle.setDescription((String)this.context.getProperty(LIRBARY_DESCRIPTION_PROPERTY));
            if (clientJarFile != null) {
                FileArtifact binariesJar = new FileArtifact(this.getName(), "java.json.client.library.binaries", clientJarFile);
                binariesJar.setDescription("The binaries for the Java JSON client library.");
                binariesJar.setPublic(false);
                binariesJar.setArtifactType(ArtifactType.binaries);
                artifactBundle.addArtifact(binariesJar);
                this.enunciate.addArtifact((Artifact)binariesJar);
            }
            if (clientSourcesJarFile != null) {
                FileArtifact sourcesJar = new FileArtifact(this.getName(), "java.json.client.library.sources", clientSourcesJarFile);
                sourcesJar.setDescription("The sources for the Java JSON client library.");
                sourcesJar.setPublic(false);
                sourcesJar.setArtifactType(ArtifactType.sources);
                artifactBundle.addArtifact(sourcesJar);
                this.enunciate.addArtifact((Artifact)sourcesJar);
            }
            if (clientJarFile != null || clientSourcesJarFile != null) {
                this.enunciate.addArtifact((Artifact)artifactBundle);
            }
        }
        catch (IOException e) {
            throw new EnunciateException((Throwable)e);
        }
        return packageDir;
    }

    protected File getPackageDir() {
        return new File(new File(this.enunciate.getBuildDir(), this.getName()), "build");
    }

    protected String readLibraryDescription(Map<String, Object> model) {
        model.put("sample_resource", this.findExampleResourceMethod());
        model.put("mediaTypeFor", new MediaTypeForMethod());
        URL res = JavaJSONClientModule.class.getResource("library_description.fmt");
        try {
            return this.processTemplate(res, model);
        }
        catch (TemplateException | IOException e) {
            throw new EnunciateException(e);
        }
    }

    public Method findExampleResourceMethod() {
        Method example = null;
        if (this.jaxrsModule != null) {
            List resourceGroups = this.jaxrsModule.getJaxrsContext().getResourceGroups((ApiRegistrationContext)new DefaultRegistrationContext(this.context));
            for (ResourceGroup resourceGroup : resourceGroups) {
                List resources = resourceGroup.getResources();
                for (Resource resource : resources) {
                    for (Method method : resource.getMethods()) {
                        if (!this.hasXmlResponseEntity(method)) continue;
                        if (this.hasXmlRequestEntity(method)) {
                            return method;
                        }
                        example = example == null ? method : example;
                    }
                }
            }
        }
        return example;
    }

    private boolean hasXmlResponseEntity(Method method) {
        if (method.getResponseEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getResponseEntity().getMediaTypes()) {
                String syntax = mediaTypeDescriptor.getSyntax();
                if (!"JSON".equals(syntax)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasXmlRequestEntity(Method method) {
        if (method.getRequestEntity() != null) {
            for (MediaTypeDescriptor mediaTypeDescriptor : method.getRequestEntity().getMediaTypes()) {
                String syntax = mediaTypeDescriptor.getSyntax();
                if (!"JSON".equals(syntax)) continue;
                return true;
            }
        }
        return false;
    }

    protected URL getTemplateURL(String template) {
        return JavaJSONClientModule.class.getResource(template);
    }

    public String getJarName() {
        return this.config.getString("[@jarName]", this.getSlug() + "-json-client.jar");
    }

    public String getGroupId() {
        return this.config.getString("[@groupId]", null);
    }

    public String getArtifactId() {
        return this.config.getString("[@artifactId]", null);
    }

    public String getVersion() {
        return this.config.getString("[@version]", null);
    }

    public String getJavacSource() {
        return this.config.getString("[@javac-source]", "8");
    }

    public String getJavacTarget() {
        return this.config.getString("[@javac-target]", "8");
    }

    public Map<String, String> getClientPackageConversions() {
        List conversionElements = this.config.configurationsAt("package-conversions.convert");
        HashMap<String, String> conversions = new HashMap<String, String>();
        conversions.put("java.lang.Exception", "client.java.lang.Exception");
        conversions.put("java.util.Map.Entry", "java.util.Map.Entry");
        for (HierarchicalConfiguration conversionElement : conversionElements) {
            conversions.put(conversionElement.getString("[@from]"), conversionElement.getString("[@to]"));
        }
        return conversions;
    }

    public Set<String> getServerSideTypesToUse() {
        List typeElements = this.config.configurationsAt("server-side-type");
        TreeSet<String> types = new TreeSet<String>();
        for (HierarchicalConfiguration typeElement : typeElements) {
            types.add(typeElement.getString("[@pattern]"));
        }
        return types;
    }

    public String getSlug() {
        return this.config.getString("[@slug]", this.enunciate.getConfiguration().getSlug());
    }

    public boolean isBundleSourcesWithClasses() {
        return this.config.getBoolean("[@bundleSourcesWithClasses]", false);
    }

    public List<File> getProjectSources() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestSources() {
        return Collections.singletonList(this.getSourceDir());
    }

    public List<File> getProjectResourceDirectories() {
        return Collections.emptyList();
    }

    public List<File> getProjectTestResourceDirectories() {
        return Collections.singletonList(this.getResourcesDir());
    }

    public boolean isDisableCompile() {
        return this.config.getBoolean("[@disableCompile]", this.jacksonModule == null || !this.jacksonModule.isJacksonDetected());
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }
}

