/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.csharp_client;

import com.webcohesion.enunciate.modules.jaxws.model.WebMethod;
import com.webcohesion.enunciate.modules.jaxws.model.WebParam;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import jakarta.jws.soap.SOAPBinding;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;

public class RequestDocumentQNameMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The requestQName method method must have a web method as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = FreemarkerUtil.unwrap((TemplateModel)from);
        if (!(unwrapped instanceof WebMethod)) {
            throw new TemplateModelException("A web method must be provided.");
        }
        WebMethod webMethod = (WebMethod)unwrapped;
        if (webMethod.getSoapBindingStyle() != SOAPBinding.Style.DOCUMENT || webMethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            throw new TemplateModelException("No request document qname available for a " + String.valueOf(webMethod.getSoapBindingStyle()) + "/" + String.valueOf(webMethod.getSoapUse()) + " web method.");
        }
        if (webMethod.getRequestWrapper() != null) {
            return new QName(webMethod.getRequestWrapper().getElementNamespace(), webMethod.getRequestWrapper().getElementName());
        }
        if (webMethod.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            Collection params = webMethod.getWebParameters();
            for (WebParam param : params) {
                if (param.isHeader()) continue;
                return new QName(webMethod.getDeclaringEndpointInterface().getTargetNamespace(), param.getElementName());
            }
        }
        return null;
    }
}

