/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWAIdentifier;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.WIP;
import java.security.PrivateKey;

@WIP
public class AndroidSafetyNetAuthenticator
extends WebAuthnModelAuthenticator {
    private PrivateKey attestationPrivateKey;
    private AttestationCertificatePath attestationCertificatePath;

    @Override
    protected AttestationStatement generateAttestationStatement(byte[] signedData, RegistrationEmulationOption registrationEmulationOption) {
        if (registrationEmulationOption.isSignatureOverrideEnabled()) {
            byte[] signature = registrationEmulationOption.getSignature();
        } else {
            byte[] signature = TestDataUtil.calculateSignature(this.attestationPrivateKey, signedData);
        }
        JWSHeader jwsHeader = new JWSHeader(JWAIdentifier.ES256, this.attestationCertificatePath);
        String nonce = null;
        long timestampMs = 0L;
        String apkPackageName = null;
        String[] apkCertificateDigestSha256 = null;
        String apkDigestSha256 = null;
        boolean ctsProfileMatch = true;
        boolean basicIntegrity = true;
        String advice = null;
        Response response = new Response(nonce, timestampMs, apkPackageName, apkCertificateDigestSha256, apkDigestSha256, ctsProfileMatch, basicIntegrity, advice);
        String ver = "";
        JWS responseJWS = null;
        return new AndroidSafetyNetAttestationStatement(ver, responseJWS);
    }
}

