/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.WIP;
import java.security.PrivateKey;

@WIP
public class AndroidKeyAuthenticator
extends WebAuthnModelAuthenticator {
    private PrivateKey attestationPrivateKey;
    private AttestationCertificatePath attestationCertificatePath;

    public AndroidKeyAuthenticator(PrivateKey attestationPrivateKey, AttestationCertificatePath attestationCertificatePath) {
        this.attestationPrivateKey = attestationPrivateKey;
        this.attestationCertificatePath = attestationCertificatePath;
    }

    @Override
    protected AttestationStatement generateAttestationStatement(byte[] signedData, RegistrationEmulationOption registrationEmulationOption) {
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : TestDataUtil.calculateSignature(this.attestationPrivateKey, signedData);
        return new AndroidKeyAttestationStatement(COSEAlgorithmIdentifier.ES256, signature, this.attestationCertificatePath);
    }
}

